<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomCategoryGroupType StructType
 * @subpackage Structs
 */
class CustomCategoryGroupType extends AbstractStructBase
{
    /**
     * The CustomCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomCategoryType[]
     */
    public $CustomCategory;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CustomCategoryGroupType
     * @uses CustomCategoryGroupType::setCustomCategory()
     * @uses CustomCategoryGroupType::setName()
     * @param \StructType\CustomCategoryType[] $customCategory
     * @param string $name
     */
    public function __construct(array $customCategory = array(), $name = null)
    {
        $this
            ->setCustomCategory($customCategory)
            ->setName($name);
    }
    /**
     * Get CustomCategory value
     * @return \StructType\CustomCategoryType[]|null
     */
    public function getCustomCategory()
    {
        return $this->CustomCategory;
    }
    /**
     * Set CustomCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomCategoryType[] $customCategory
     * @return \StructType\CustomCategoryGroupType
     */
    public function setCustomCategory(array $customCategory = array())
    {
        foreach ($customCategory as $customCategoryGroupTypeCustomCategoryItem) {
            // validation for constraint: itemType
            if (!$customCategoryGroupTypeCustomCategoryItem instanceof \StructType\CustomCategoryType) {
                throw new \InvalidArgumentException(sprintf('The CustomCategory property can only contain items of \StructType\CustomCategoryType, "%s" given', is_object($customCategoryGroupTypeCustomCategoryItem) ? get_class($customCategoryGroupTypeCustomCategoryItem) : gettype($customCategoryGroupTypeCustomCategoryItem)), __LINE__);
            }
        }
        $this->CustomCategory = $customCategory;
        return $this;
    }
    /**
     * Add item to CustomCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomCategoryType $item
     * @return \StructType\CustomCategoryGroupType
     */
    public function addToCustomCategory(\StructType\CustomCategoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomCategoryType) {
            throw new \InvalidArgumentException(sprintf('The CustomCategory property can only contain items of \StructType\CustomCategoryType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomCategory[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CustomCategoryGroupType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomCategoryGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
