<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionPoliciesType StructType
 * @subpackage Structs
 */
class CommissionPoliciesType extends AbstractStructBase
{
    /**
     * The CommissionPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionPolicyType[]
     */
    public $CommissionPolicy;
    /**
     * The MinCommissionPercent
     * @var float
     */
    public $MinCommissionPercent;
    /**
     * The MaxCommissionPercent
     * @var float
     */
    public $MaxCommissionPercent;
    /**
     * Constructor method for CommissionPoliciesType
     * @uses CommissionPoliciesType::setCommissionPolicy()
     * @uses CommissionPoliciesType::setMinCommissionPercent()
     * @uses CommissionPoliciesType::setMaxCommissionPercent()
     * @param \StructType\CommissionPolicyType[] $commissionPolicy
     * @param float $minCommissionPercent
     * @param float $maxCommissionPercent
     */
    public function __construct(array $commissionPolicy = array(), $minCommissionPercent = null, $maxCommissionPercent = null)
    {
        $this
            ->setCommissionPolicy($commissionPolicy)
            ->setMinCommissionPercent($minCommissionPercent)
            ->setMaxCommissionPercent($maxCommissionPercent);
    }
    /**
     * Get CommissionPolicy value
     * @return \StructType\CommissionPolicyType[]|null
     */
    public function getCommissionPolicy()
    {
        return $this->CommissionPolicy;
    }
    /**
     * Set CommissionPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionPolicyType[] $commissionPolicy
     * @return \StructType\CommissionPoliciesType
     */
    public function setCommissionPolicy(array $commissionPolicy = array())
    {
        foreach ($commissionPolicy as $commissionPoliciesTypeCommissionPolicyItem) {
            // validation for constraint: itemType
            if (!$commissionPoliciesTypeCommissionPolicyItem instanceof \StructType\CommissionPolicyType) {
                throw new \InvalidArgumentException(sprintf('The CommissionPolicy property can only contain items of \StructType\CommissionPolicyType, "%s" given', is_object($commissionPoliciesTypeCommissionPolicyItem) ? get_class($commissionPoliciesTypeCommissionPolicyItem) : gettype($commissionPoliciesTypeCommissionPolicyItem)), __LINE__);
            }
        }
        $this->CommissionPolicy = $commissionPolicy;
        return $this;
    }
    /**
     * Add item to CommissionPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionPolicyType $item
     * @return \StructType\CommissionPoliciesType
     */
    public function addToCommissionPolicy(\StructType\CommissionPolicyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionPolicyType) {
            throw new \InvalidArgumentException(sprintf('The CommissionPolicy property can only contain items of \StructType\CommissionPolicyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommissionPolicy[] = $item;
        return $this;
    }
    /**
     * Get MinCommissionPercent value
     * @return float|null
     */
    public function getMinCommissionPercent()
    {
        return $this->MinCommissionPercent;
    }
    /**
     * Set MinCommissionPercent value
     * @param float $minCommissionPercent
     * @return \StructType\CommissionPoliciesType
     */
    public function setMinCommissionPercent($minCommissionPercent = null)
    {
        $this->MinCommissionPercent = $minCommissionPercent;
        return $this;
    }
    /**
     * Get MaxCommissionPercent value
     * @return float|null
     */
    public function getMaxCommissionPercent()
    {
        return $this->MaxCommissionPercent;
    }
    /**
     * Set MaxCommissionPercent value
     * @param float $maxCommissionPercent
     * @return \StructType\CommissionPoliciesType
     */
    public function setMaxCommissionPercent($maxCommissionPercent = null)
    {
        $this->MaxCommissionPercent = $maxCommissionPercent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionPoliciesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
