<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgreementsType StructType
 * @subpackage Structs
 */
class AgreementsType extends AbstractStructBase
{
    /**
     * The Certification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CertificationType[]
     */
    public $Certification;
    /**
     * The AllianceConsortium
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AllianceConsortiumType[]
     */
    public $AllianceConsortium;
    /**
     * The CommissionInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionInfoType[]
     */
    public $CommissionInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AgreementsType
     * @uses AgreementsType::setCertification()
     * @uses AgreementsType::setAllianceConsortium()
     * @uses AgreementsType::setCommissionInfo()
     * @uses AgreementsType::setTPA_Extensions()
     * @uses AgreementsType::setShareSynchInd()
     * @uses AgreementsType::setShareMarketInd()
     * @param \StructType\CertificationType[] $certification
     * @param \StructType\AllianceConsortiumType[] $allianceConsortium
     * @param \StructType\CommissionInfoType[] $commissionInfo
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $certification = array(), array $allianceConsortium = array(), array $commissionInfo = array(), \StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setCertification($certification)
            ->setAllianceConsortium($allianceConsortium)
            ->setCommissionInfo($commissionInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get Certification value
     * @return \StructType\CertificationType[]|null
     */
    public function getCertification()
    {
        return $this->Certification;
    }
    /**
     * Set Certification value
     * @throws \InvalidArgumentException
     * @param \StructType\CertificationType[] $certification
     * @return \StructType\AgreementsType
     */
    public function setCertification(array $certification = array())
    {
        foreach ($certification as $agreementsTypeCertificationItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeCertificationItem instanceof \StructType\CertificationType) {
                throw new \InvalidArgumentException(sprintf('The Certification property can only contain items of \StructType\CertificationType, "%s" given', is_object($agreementsTypeCertificationItem) ? get_class($agreementsTypeCertificationItem) : gettype($agreementsTypeCertificationItem)), __LINE__);
            }
        }
        $this->Certification = $certification;
        return $this;
    }
    /**
     * Add item to Certification value
     * @throws \InvalidArgumentException
     * @param \StructType\CertificationType $item
     * @return \StructType\AgreementsType
     */
    public function addToCertification(\StructType\CertificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CertificationType) {
            throw new \InvalidArgumentException(sprintf('The Certification property can only contain items of \StructType\CertificationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Certification[] = $item;
        return $this;
    }
    /**
     * Get AllianceConsortium value
     * @return \StructType\AllianceConsortiumType[]|null
     */
    public function getAllianceConsortium()
    {
        return $this->AllianceConsortium;
    }
    /**
     * Set AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceConsortiumType[] $allianceConsortium
     * @return \StructType\AgreementsType
     */
    public function setAllianceConsortium(array $allianceConsortium = array())
    {
        foreach ($allianceConsortium as $agreementsTypeAllianceConsortiumItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeAllianceConsortiumItem instanceof \StructType\AllianceConsortiumType) {
                throw new \InvalidArgumentException(sprintf('The AllianceConsortium property can only contain items of \StructType\AllianceConsortiumType, "%s" given', is_object($agreementsTypeAllianceConsortiumItem) ? get_class($agreementsTypeAllianceConsortiumItem) : gettype($agreementsTypeAllianceConsortiumItem)), __LINE__);
            }
        }
        $this->AllianceConsortium = $allianceConsortium;
        return $this;
    }
    /**
     * Add item to AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceConsortiumType $item
     * @return \StructType\AgreementsType
     */
    public function addToAllianceConsortium(\StructType\AllianceConsortiumType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllianceConsortiumType) {
            throw new \InvalidArgumentException(sprintf('The AllianceConsortium property can only contain items of \StructType\AllianceConsortiumType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AllianceConsortium[] = $item;
        return $this;
    }
    /**
     * Get CommissionInfo value
     * @return \StructType\CommissionInfoType[]|null
     */
    public function getCommissionInfo()
    {
        return $this->CommissionInfo;
    }
    /**
     * Set CommissionInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionInfoType[] $commissionInfo
     * @return \StructType\AgreementsType
     */
    public function setCommissionInfo(array $commissionInfo = array())
    {
        foreach ($commissionInfo as $agreementsTypeCommissionInfoItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeCommissionInfoItem instanceof \StructType\CommissionInfoType) {
                throw new \InvalidArgumentException(sprintf('The CommissionInfo property can only contain items of \StructType\CommissionInfoType, "%s" given', is_object($agreementsTypeCommissionInfoItem) ? get_class($agreementsTypeCommissionInfoItem) : gettype($agreementsTypeCommissionInfoItem)), __LINE__);
            }
        }
        $this->CommissionInfo = $commissionInfo;
        return $this;
    }
    /**
     * Add item to CommissionInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionInfoType $item
     * @return \StructType\AgreementsType
     */
    public function addToCommissionInfo(\StructType\CommissionInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionInfoType) {
            throw new \InvalidArgumentException(sprintf('The CommissionInfo property can only contain items of \StructType\CommissionInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommissionInfo[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\AgreementsType
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\AgreementsType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\AgreementsType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AgreementsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
