<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Property ServiceType
 * @subpackage Services
 */
class Property extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PropertyManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_PropertyManagerRQ $eVRN_PropertyManagerRQ
     * @return \StructType\EVRN_PropertyManagerRS|bool
     */
    public function PropertyManager(\StructType\EVRN_PropertyManagerRQ $eVRN_PropertyManagerRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->PropertyManager($eVRN_PropertyManagerRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EVRN_PropertyManagerRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
