<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMembershipTypeMembership ArrayType
 * @subpackage Arrays
 */
class ArrayOfMembershipTypeMembership extends AbstractStructArrayBase
{
    /**
     * The Membership
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Membership[]
     */
    public $Membership;
    /**
     * Constructor method for ArrayOfMembershipTypeMembership
     * @uses ArrayOfMembershipTypeMembership::setMembership()
     * @param \StructType\Membership[] $membership
     */
    public function __construct(array $membership = array())
    {
        $this
            ->setMembership($membership);
    }
    /**
     * Get Membership value
     * @return \StructType\Membership[]|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * Set Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership[] $membership
     * @return \ArrayType\ArrayOfMembershipTypeMembership
     */
    public function setMembership(array $membership = array())
    {
        foreach ($membership as $arrayOfMembershipTypeMembershipMembershipItem) {
            // validation for constraint: itemType
            if (!$arrayOfMembershipTypeMembershipMembershipItem instanceof \StructType\Membership) {
                throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \StructType\Membership, "%s" given', is_object($arrayOfMembershipTypeMembershipMembershipItem) ? get_class($arrayOfMembershipTypeMembershipMembershipItem) : gettype($arrayOfMembershipTypeMembershipMembershipItem)), __LINE__);
            }
        }
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Add item to Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership $item
     * @return \ArrayType\ArrayOfMembershipTypeMembership
     */
    public function addToMembership(\StructType\Membership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Membership) {
            throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \StructType\Membership, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Membership[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Membership|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Membership|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Membership|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Membership|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Membership|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Membership
     */
    public function getAttributeName()
    {
        return 'Membership';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMembershipTypeMembership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
