<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordReqMarketData StructType
 * @subpackage Structs
 */
class RecordReqMarketData extends AbstractStructBase
{
    /**
     * The SessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SessionID;
    /**
     * The InstrumentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstrumentID;
    /**
     * Constructor method for RecordReqMarketData
     * @uses RecordReqMarketData::setSessionID()
     * @uses RecordReqMarketData::setInstrumentID()
     * @param int $sessionID
     * @param string $instrumentID
     */
    public function __construct($sessionID = null, $instrumentID = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setInstrumentID($instrumentID);
    }
    /**
     * Get SessionID value
     * @return int
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param int $sessionID
     * @return \StructType\RecordReqMarketData
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: int
        if (!is_null($sessionID) && !(is_int($sessionID) || ctype_digit($sessionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get InstrumentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstrumentID()
    {
        return isset($this->InstrumentID) ? $this->InstrumentID : null;
    }
    /**
     * Set InstrumentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instrumentID
     * @return \StructType\RecordReqMarketData
     */
    public function setInstrumentID($instrumentID = null)
    {
        // validation for constraint: string
        if (!is_null($instrumentID) && !is_string($instrumentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instrumentID, true), gettype($instrumentID)), __LINE__);
        }
        if (is_null($instrumentID) || (is_array($instrumentID) && empty($instrumentID))) {
            unset($this->InstrumentID);
        } else {
            $this->InstrumentID = $instrumentID;
        }
        return $this;
    }
}
