<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Qry ServiceType
 * @subpackage Services
 */
class Qry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QryInstrument
     * Meta information extracted from the WSDL
     * - documentation: Service definition of function ns__QryInstrument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecordReqInstrument $req
     * @return string|bool
     */
    public function QryInstrument(\StructType\RecordReqInstrument $req)
    {
        try {
            $this->setResult($this->getSoapClient()->QryInstrument($req));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QryMarketData
     * Meta information extracted from the WSDL
     * - documentation: Service definition of function ns__QryMarketData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecordReqMarketData $req
     * @return string|bool
     */
    public function QryMarketData(\StructType\RecordReqMarketData $req)
    {
        try {
            $this->setResult($this->getSoapClient()->QryMarketData($req));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
