<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnTemplateObject StructType
 * @subpackage Structs
 */
class ReturnTemplateObject extends AbstractStructBase
{
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The InfoMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $InfoMessage;
    /**
     * The InnerException
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InnerException;
    /**
     * Constructor method for ReturnTemplateObject
     * @uses ReturnTemplateObject::setErrorMessage()
     * @uses ReturnTemplateObject::setInfoMessage()
     * @uses ReturnTemplateObject::setInnerException()
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfString $infoMessage
     * @param string $innerException
     */
    public function __construct($errorMessage = null, \ArrayType\ArrayOfString $infoMessage = null, $innerException = null)
    {
        $this
            ->setErrorMessage($errorMessage)
            ->setInfoMessage($infoMessage)
            ->setInnerException($innerException);
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\ReturnTemplateObject
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get InfoMessage value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getInfoMessage()
    {
        return $this->InfoMessage;
    }
    /**
     * Set InfoMessage value
     * @param \ArrayType\ArrayOfString $infoMessage
     * @return \StructType\ReturnTemplateObject
     */
    public function setInfoMessage(\ArrayType\ArrayOfString $infoMessage = null)
    {
        $this->InfoMessage = $infoMessage;
        return $this;
    }
    /**
     * Get InnerException value
     * @return string|null
     */
    public function getInnerException()
    {
        return $this->InnerException;
    }
    /**
     * Set InnerException value
     * @param string $innerException
     * @return \StructType\ReturnTemplateObject
     */
    public function setInnerException($innerException = null)
    {
        // validation for constraint: string
        if (!is_null($innerException) && !is_string($innerException)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($innerException, true), gettype($innerException)), __LINE__);
        }
        $this->InnerException = $innerException;
        return $this;
    }
}
