<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * @subpackage Structs
 */
class Order extends ReturnTemplateObject
{
    /**
     * The OrderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderDate;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryDate;
    /**
     * The NoPartialDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoPartialDelivery;
    /**
     * The OrderValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OrderValue;
    /**
     * The EndCustomerOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EndCustomerOrder;
    /**
     * The CODAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CODAmount;
    /**
     * The WayOfDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WayOfDelivery;
    /**
     * The AssemblyOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AssemblyOrder;
    /**
     * The HaltOnWarning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HaltOnWarning;
    /**
     * The HaltOnError
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HaltOnError;
    /**
     * The HaltOnPriceDifference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HaltOnPriceDifference;
    /**
     * The HaltOnDuplicateCustomerPurchaseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HaltOnDuplicateCustomerPurchaseNumber;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNumber;
    /**
     * The CapTechReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CapTechReference;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference;
    /**
     * The ShipmentMark
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentMark;
    /**
     * The CustomerPurchaseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerPurchaseNumber;
    /**
     * The ContactEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmail;
    /**
     * The Spare01
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare01;
    /**
     * The Spare02
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare02;
    /**
     * The Spare03
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare03;
    /**
     * The Spare04
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare04;
    /**
     * The Spare05
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare05;
    /**
     * The Spare06
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare06;
    /**
     * The Spare07
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare07;
    /**
     * The Spare08
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare08;
    /**
     * The Spare09
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare09;
    /**
     * The Spare10
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare10;
    /**
     * The OrderLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderLine
     */
    public $OrderLines;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderDeliveryAddress
     */
    public $DeliveryAddress;
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Invoices;
    /**
     * The Parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Parcels;
    /**
     * Constructor method for Order
     * @uses Order::setOrderDate()
     * @uses Order::setDeliveryDate()
     * @uses Order::setNoPartialDelivery()
     * @uses Order::setOrderValue()
     * @uses Order::setEndCustomerOrder()
     * @uses Order::setCODAmount()
     * @uses Order::setWayOfDelivery()
     * @uses Order::setAssemblyOrder()
     * @uses Order::setHaltOnWarning()
     * @uses Order::setHaltOnError()
     * @uses Order::setHaltOnPriceDifference()
     * @uses Order::setHaltOnDuplicateCustomerPurchaseNumber()
     * @uses Order::setOrderNumber()
     * @uses Order::setCapTechReference()
     * @uses Order::setCustomerReference()
     * @uses Order::setShipmentMark()
     * @uses Order::setCustomerPurchaseNumber()
     * @uses Order::setContactEmail()
     * @uses Order::setSpare01()
     * @uses Order::setSpare02()
     * @uses Order::setSpare03()
     * @uses Order::setSpare04()
     * @uses Order::setSpare05()
     * @uses Order::setSpare06()
     * @uses Order::setSpare07()
     * @uses Order::setSpare08()
     * @uses Order::setSpare09()
     * @uses Order::setSpare10()
     * @uses Order::setOrderLines()
     * @uses Order::setDeliveryAddress()
     * @uses Order::setInvoices()
     * @uses Order::setParcels()
     * @param string $orderDate
     * @param string $deliveryDate
     * @param bool $noPartialDelivery
     * @param float $orderValue
     * @param bool $endCustomerOrder
     * @param int $cODAmount
     * @param string $wayOfDelivery
     * @param bool $assemblyOrder
     * @param bool $haltOnWarning
     * @param bool $haltOnError
     * @param bool $haltOnPriceDifference
     * @param bool $haltOnDuplicateCustomerPurchaseNumber
     * @param string $orderNumber
     * @param string $capTechReference
     * @param string $customerReference
     * @param string $shipmentMark
     * @param string $customerPurchaseNumber
     * @param string $contactEmail
     * @param string $spare01
     * @param string $spare02
     * @param string $spare03
     * @param string $spare04
     * @param string $spare05
     * @param string $spare06
     * @param string $spare07
     * @param string $spare08
     * @param string $spare09
     * @param string $spare10
     * @param \ArrayType\ArrayOfOrderLine $orderLines
     * @param \StructType\OrderDeliveryAddress $deliveryAddress
     * @param \ArrayType\ArrayOfString $invoices
     * @param \ArrayType\ArrayOfString $parcels
     */
    public function __construct($orderDate = null, $deliveryDate = null, $noPartialDelivery = null, $orderValue = null, $endCustomerOrder = null, $cODAmount = null, $wayOfDelivery = null, $assemblyOrder = null, $haltOnWarning = null, $haltOnError = null, $haltOnPriceDifference = null, $haltOnDuplicateCustomerPurchaseNumber = null, $orderNumber = null, $capTechReference = null, $customerReference = null, $shipmentMark = null, $customerPurchaseNumber = null, $contactEmail = null, $spare01 = null, $spare02 = null, $spare03 = null, $spare04 = null, $spare05 = null, $spare06 = null, $spare07 = null, $spare08 = null, $spare09 = null, $spare10 = null, \ArrayType\ArrayOfOrderLine $orderLines = null, \StructType\OrderDeliveryAddress $deliveryAddress = null, \ArrayType\ArrayOfString $invoices = null, \ArrayType\ArrayOfString $parcels = null)
    {
        $this
            ->setOrderDate($orderDate)
            ->setDeliveryDate($deliveryDate)
            ->setNoPartialDelivery($noPartialDelivery)
            ->setOrderValue($orderValue)
            ->setEndCustomerOrder($endCustomerOrder)
            ->setCODAmount($cODAmount)
            ->setWayOfDelivery($wayOfDelivery)
            ->setAssemblyOrder($assemblyOrder)
            ->setHaltOnWarning($haltOnWarning)
            ->setHaltOnError($haltOnError)
            ->setHaltOnPriceDifference($haltOnPriceDifference)
            ->setHaltOnDuplicateCustomerPurchaseNumber($haltOnDuplicateCustomerPurchaseNumber)
            ->setOrderNumber($orderNumber)
            ->setCapTechReference($capTechReference)
            ->setCustomerReference($customerReference)
            ->setShipmentMark($shipmentMark)
            ->setCustomerPurchaseNumber($customerPurchaseNumber)
            ->setContactEmail($contactEmail)
            ->setSpare01($spare01)
            ->setSpare02($spare02)
            ->setSpare03($spare03)
            ->setSpare04($spare04)
            ->setSpare05($spare05)
            ->setSpare06($spare06)
            ->setSpare07($spare07)
            ->setSpare08($spare08)
            ->setSpare09($spare09)
            ->setSpare10($spare10)
            ->setOrderLines($orderLines)
            ->setDeliveryAddress($deliveryAddress)
            ->setInvoices($invoices)
            ->setParcels($parcels);
    }
    /**
     * Get OrderDate value
     * @return string
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \StructType\Order
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\Order
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get NoPartialDelivery value
     * @return bool
     */
    public function getNoPartialDelivery()
    {
        return $this->NoPartialDelivery;
    }
    /**
     * Set NoPartialDelivery value
     * @param bool $noPartialDelivery
     * @return \StructType\Order
     */
    public function setNoPartialDelivery($noPartialDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($noPartialDelivery) && !is_bool($noPartialDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noPartialDelivery, true), gettype($noPartialDelivery)), __LINE__);
        }
        $this->NoPartialDelivery = $noPartialDelivery;
        return $this;
    }
    /**
     * Get OrderValue value
     * @return float
     */
    public function getOrderValue()
    {
        return $this->OrderValue;
    }
    /**
     * Set OrderValue value
     * @param float $orderValue
     * @return \StructType\Order
     */
    public function setOrderValue($orderValue = null)
    {
        // validation for constraint: float
        if (!is_null($orderValue) && !(is_float($orderValue) || is_numeric($orderValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderValue, true), gettype($orderValue)), __LINE__);
        }
        $this->OrderValue = $orderValue;
        return $this;
    }
    /**
     * Get EndCustomerOrder value
     * @return bool
     */
    public function getEndCustomerOrder()
    {
        return $this->EndCustomerOrder;
    }
    /**
     * Set EndCustomerOrder value
     * @param bool $endCustomerOrder
     * @return \StructType\Order
     */
    public function setEndCustomerOrder($endCustomerOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($endCustomerOrder) && !is_bool($endCustomerOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($endCustomerOrder, true), gettype($endCustomerOrder)), __LINE__);
        }
        $this->EndCustomerOrder = $endCustomerOrder;
        return $this;
    }
    /**
     * Get CODAmount value
     * @return int
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param int $cODAmount
     * @return \StructType\Order
     */
    public function setCODAmount($cODAmount = null)
    {
        // validation for constraint: int
        if (!is_null($cODAmount) && !(is_int($cODAmount) || ctype_digit($cODAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cODAmount, true), gettype($cODAmount)), __LINE__);
        }
        $this->CODAmount = $cODAmount;
        return $this;
    }
    /**
     * Get WayOfDelivery value
     * @return string
     */
    public function getWayOfDelivery()
    {
        return $this->WayOfDelivery;
    }
    /**
     * Set WayOfDelivery value
     * @uses \EnumType\WayOfDeliveryEnum::valueIsValid()
     * @uses \EnumType\WayOfDeliveryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wayOfDelivery
     * @return \StructType\Order
     */
    public function setWayOfDelivery($wayOfDelivery = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WayOfDeliveryEnum::valueIsValid($wayOfDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WayOfDeliveryEnum', is_array($wayOfDelivery) ? implode(', ', $wayOfDelivery) : var_export($wayOfDelivery, true), implode(', ', \EnumType\WayOfDeliveryEnum::getValidValues())), __LINE__);
        }
        $this->WayOfDelivery = $wayOfDelivery;
        return $this;
    }
    /**
     * Get AssemblyOrder value
     * @return bool
     */
    public function getAssemblyOrder()
    {
        return $this->AssemblyOrder;
    }
    /**
     * Set AssemblyOrder value
     * @param bool $assemblyOrder
     * @return \StructType\Order
     */
    public function setAssemblyOrder($assemblyOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($assemblyOrder) && !is_bool($assemblyOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($assemblyOrder, true), gettype($assemblyOrder)), __LINE__);
        }
        $this->AssemblyOrder = $assemblyOrder;
        return $this;
    }
    /**
     * Get HaltOnWarning value
     * @return bool
     */
    public function getHaltOnWarning()
    {
        return $this->HaltOnWarning;
    }
    /**
     * Set HaltOnWarning value
     * @param bool $haltOnWarning
     * @return \StructType\Order
     */
    public function setHaltOnWarning($haltOnWarning = null)
    {
        // validation for constraint: boolean
        if (!is_null($haltOnWarning) && !is_bool($haltOnWarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($haltOnWarning, true), gettype($haltOnWarning)), __LINE__);
        }
        $this->HaltOnWarning = $haltOnWarning;
        return $this;
    }
    /**
     * Get HaltOnError value
     * @return bool
     */
    public function getHaltOnError()
    {
        return $this->HaltOnError;
    }
    /**
     * Set HaltOnError value
     * @param bool $haltOnError
     * @return \StructType\Order
     */
    public function setHaltOnError($haltOnError = null)
    {
        // validation for constraint: boolean
        if (!is_null($haltOnError) && !is_bool($haltOnError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($haltOnError, true), gettype($haltOnError)), __LINE__);
        }
        $this->HaltOnError = $haltOnError;
        return $this;
    }
    /**
     * Get HaltOnPriceDifference value
     * @return bool
     */
    public function getHaltOnPriceDifference()
    {
        return $this->HaltOnPriceDifference;
    }
    /**
     * Set HaltOnPriceDifference value
     * @param bool $haltOnPriceDifference
     * @return \StructType\Order
     */
    public function setHaltOnPriceDifference($haltOnPriceDifference = null)
    {
        // validation for constraint: boolean
        if (!is_null($haltOnPriceDifference) && !is_bool($haltOnPriceDifference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($haltOnPriceDifference, true), gettype($haltOnPriceDifference)), __LINE__);
        }
        $this->HaltOnPriceDifference = $haltOnPriceDifference;
        return $this;
    }
    /**
     * Get HaltOnDuplicateCustomerPurchaseNumber value
     * @return bool
     */
    public function getHaltOnDuplicateCustomerPurchaseNumber()
    {
        return $this->HaltOnDuplicateCustomerPurchaseNumber;
    }
    /**
     * Set HaltOnDuplicateCustomerPurchaseNumber value
     * @param bool $haltOnDuplicateCustomerPurchaseNumber
     * @return \StructType\Order
     */
    public function setHaltOnDuplicateCustomerPurchaseNumber($haltOnDuplicateCustomerPurchaseNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($haltOnDuplicateCustomerPurchaseNumber) && !is_bool($haltOnDuplicateCustomerPurchaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($haltOnDuplicateCustomerPurchaseNumber, true), gettype($haltOnDuplicateCustomerPurchaseNumber)), __LINE__);
        }
        $this->HaltOnDuplicateCustomerPurchaseNumber = $haltOnDuplicateCustomerPurchaseNumber;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\Order
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get CapTechReference value
     * @return string|null
     */
    public function getCapTechReference()
    {
        return $this->CapTechReference;
    }
    /**
     * Set CapTechReference value
     * @param string $capTechReference
     * @return \StructType\Order
     */
    public function setCapTechReference($capTechReference = null)
    {
        // validation for constraint: string
        if (!is_null($capTechReference) && !is_string($capTechReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($capTechReference, true), gettype($capTechReference)), __LINE__);
        }
        $this->CapTechReference = $capTechReference;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param string $customerReference
     * @return \StructType\Order
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Get ShipmentMark value
     * @return string|null
     */
    public function getShipmentMark()
    {
        return $this->ShipmentMark;
    }
    /**
     * Set ShipmentMark value
     * @param string $shipmentMark
     * @return \StructType\Order
     */
    public function setShipmentMark($shipmentMark = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentMark) && !is_string($shipmentMark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentMark, true), gettype($shipmentMark)), __LINE__);
        }
        $this->ShipmentMark = $shipmentMark;
        return $this;
    }
    /**
     * Get CustomerPurchaseNumber value
     * @return string|null
     */
    public function getCustomerPurchaseNumber()
    {
        return $this->CustomerPurchaseNumber;
    }
    /**
     * Set CustomerPurchaseNumber value
     * @param string $customerPurchaseNumber
     * @return \StructType\Order
     */
    public function setCustomerPurchaseNumber($customerPurchaseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerPurchaseNumber) && !is_string($customerPurchaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPurchaseNumber, true), gettype($customerPurchaseNumber)), __LINE__);
        }
        $this->CustomerPurchaseNumber = $customerPurchaseNumber;
        return $this;
    }
    /**
     * Get ContactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->ContactEmail;
    }
    /**
     * Set ContactEmail value
     * @param string $contactEmail
     * @return \StructType\Order
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmail, true), gettype($contactEmail)), __LINE__);
        }
        $this->ContactEmail = $contactEmail;
        return $this;
    }
    /**
     * Get Spare01 value
     * @return string|null
     */
    public function getSpare01()
    {
        return $this->Spare01;
    }
    /**
     * Set Spare01 value
     * @param string $spare01
     * @return \StructType\Order
     */
    public function setSpare01($spare01 = null)
    {
        // validation for constraint: string
        if (!is_null($spare01) && !is_string($spare01)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare01, true), gettype($spare01)), __LINE__);
        }
        $this->Spare01 = $spare01;
        return $this;
    }
    /**
     * Get Spare02 value
     * @return string|null
     */
    public function getSpare02()
    {
        return $this->Spare02;
    }
    /**
     * Set Spare02 value
     * @param string $spare02
     * @return \StructType\Order
     */
    public function setSpare02($spare02 = null)
    {
        // validation for constraint: string
        if (!is_null($spare02) && !is_string($spare02)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare02, true), gettype($spare02)), __LINE__);
        }
        $this->Spare02 = $spare02;
        return $this;
    }
    /**
     * Get Spare03 value
     * @return string|null
     */
    public function getSpare03()
    {
        return $this->Spare03;
    }
    /**
     * Set Spare03 value
     * @param string $spare03
     * @return \StructType\Order
     */
    public function setSpare03($spare03 = null)
    {
        // validation for constraint: string
        if (!is_null($spare03) && !is_string($spare03)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare03, true), gettype($spare03)), __LINE__);
        }
        $this->Spare03 = $spare03;
        return $this;
    }
    /**
     * Get Spare04 value
     * @return string|null
     */
    public function getSpare04()
    {
        return $this->Spare04;
    }
    /**
     * Set Spare04 value
     * @param string $spare04
     * @return \StructType\Order
     */
    public function setSpare04($spare04 = null)
    {
        // validation for constraint: string
        if (!is_null($spare04) && !is_string($spare04)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare04, true), gettype($spare04)), __LINE__);
        }
        $this->Spare04 = $spare04;
        return $this;
    }
    /**
     * Get Spare05 value
     * @return string|null
     */
    public function getSpare05()
    {
        return $this->Spare05;
    }
    /**
     * Set Spare05 value
     * @param string $spare05
     * @return \StructType\Order
     */
    public function setSpare05($spare05 = null)
    {
        // validation for constraint: string
        if (!is_null($spare05) && !is_string($spare05)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare05, true), gettype($spare05)), __LINE__);
        }
        $this->Spare05 = $spare05;
        return $this;
    }
    /**
     * Get Spare06 value
     * @return string|null
     */
    public function getSpare06()
    {
        return $this->Spare06;
    }
    /**
     * Set Spare06 value
     * @param string $spare06
     * @return \StructType\Order
     */
    public function setSpare06($spare06 = null)
    {
        // validation for constraint: string
        if (!is_null($spare06) && !is_string($spare06)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare06, true), gettype($spare06)), __LINE__);
        }
        $this->Spare06 = $spare06;
        return $this;
    }
    /**
     * Get Spare07 value
     * @return string|null
     */
    public function getSpare07()
    {
        return $this->Spare07;
    }
    /**
     * Set Spare07 value
     * @param string $spare07
     * @return \StructType\Order
     */
    public function setSpare07($spare07 = null)
    {
        // validation for constraint: string
        if (!is_null($spare07) && !is_string($spare07)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare07, true), gettype($spare07)), __LINE__);
        }
        $this->Spare07 = $spare07;
        return $this;
    }
    /**
     * Get Spare08 value
     * @return string|null
     */
    public function getSpare08()
    {
        return $this->Spare08;
    }
    /**
     * Set Spare08 value
     * @param string $spare08
     * @return \StructType\Order
     */
    public function setSpare08($spare08 = null)
    {
        // validation for constraint: string
        if (!is_null($spare08) && !is_string($spare08)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare08, true), gettype($spare08)), __LINE__);
        }
        $this->Spare08 = $spare08;
        return $this;
    }
    /**
     * Get Spare09 value
     * @return string|null
     */
    public function getSpare09()
    {
        return $this->Spare09;
    }
    /**
     * Set Spare09 value
     * @param string $spare09
     * @return \StructType\Order
     */
    public function setSpare09($spare09 = null)
    {
        // validation for constraint: string
        if (!is_null($spare09) && !is_string($spare09)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare09, true), gettype($spare09)), __LINE__);
        }
        $this->Spare09 = $spare09;
        return $this;
    }
    /**
     * Get Spare10 value
     * @return string|null
     */
    public function getSpare10()
    {
        return $this->Spare10;
    }
    /**
     * Set Spare10 value
     * @param string $spare10
     * @return \StructType\Order
     */
    public function setSpare10($spare10 = null)
    {
        // validation for constraint: string
        if (!is_null($spare10) && !is_string($spare10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare10, true), gettype($spare10)), __LINE__);
        }
        $this->Spare10 = $spare10;
        return $this;
    }
    /**
     * Get OrderLines value
     * @return \ArrayType\ArrayOfOrderLine|null
     */
    public function getOrderLines()
    {
        return $this->OrderLines;
    }
    /**
     * Set OrderLines value
     * @param \ArrayType\ArrayOfOrderLine $orderLines
     * @return \StructType\Order
     */
    public function setOrderLines(\ArrayType\ArrayOfOrderLine $orderLines = null)
    {
        $this->OrderLines = $orderLines;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \StructType\OrderDeliveryAddress|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \StructType\OrderDeliveryAddress $deliveryAddress
     * @return \StructType\Order
     */
    public function setDeliveryAddress(\StructType\OrderDeliveryAddress $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get Invoices value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getInvoices()
    {
        return $this->Invoices;
    }
    /**
     * Set Invoices value
     * @param \ArrayType\ArrayOfString $invoices
     * @return \StructType\Order
     */
    public function setInvoices(\ArrayType\ArrayOfString $invoices = null)
    {
        $this->Invoices = $invoices;
        return $this;
    }
    /**
     * Get Parcels value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getParcels()
    {
        return $this->Parcels;
    }
    /**
     * Set Parcels value
     * @param \ArrayType\ArrayOfString $parcels
     * @return \StructType\Order
     */
    public function setParcels(\ArrayType\ArrayOfString $parcels = null)
    {
        $this->Parcels = $parcels;
        return $this;
    }
}
