<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends ReturnTemplateObject
{
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDate;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The AmountPaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountPaid;
    /**
     * The VATAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VATAmount;
    /**
     * The FreightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FreightAmount;
    /**
     * The HandlingFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $HandlingFee;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNumber;
    /**
     * The OrderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Order
     */
    public $OrderItem;
    /**
     * The Spare01
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare01;
    /**
     * The Spare02
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare02;
    /**
     * The Spare03
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare03;
    /**
     * The Spare04
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare04;
    /**
     * The Spare05
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare05;
    /**
     * The Spare06
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare06;
    /**
     * The Spare07
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare07;
    /**
     * The Spare08
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare08;
    /**
     * The Spare09
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare09;
    /**
     * The Spare10
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare10;
    /**
     * The InvoiceAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $InvoiceAddress;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setInvoiceDate()
     * @uses Invoice::setDueDate()
     * @uses Invoice::setAmount()
     * @uses Invoice::setAmountPaid()
     * @uses Invoice::setVATAmount()
     * @uses Invoice::setFreightAmount()
     * @uses Invoice::setHandlingFee()
     * @uses Invoice::setInvoiceNumber()
     * @uses Invoice::setOrderNumber()
     * @uses Invoice::setOrderItem()
     * @uses Invoice::setSpare01()
     * @uses Invoice::setSpare02()
     * @uses Invoice::setSpare03()
     * @uses Invoice::setSpare04()
     * @uses Invoice::setSpare05()
     * @uses Invoice::setSpare06()
     * @uses Invoice::setSpare07()
     * @uses Invoice::setSpare08()
     * @uses Invoice::setSpare09()
     * @uses Invoice::setSpare10()
     * @uses Invoice::setInvoiceAddress()
     * @param string $invoiceDate
     * @param string $dueDate
     * @param float $amount
     * @param float $amountPaid
     * @param float $vATAmount
     * @param float $freightAmount
     * @param float $handlingFee
     * @param string $invoiceNumber
     * @param string $orderNumber
     * @param \StructType\Order $orderItem
     * @param string $spare01
     * @param string $spare02
     * @param string $spare03
     * @param string $spare04
     * @param string $spare05
     * @param string $spare06
     * @param string $spare07
     * @param string $spare08
     * @param string $spare09
     * @param string $spare10
     * @param \StructType\Address $invoiceAddress
     */
    public function __construct($invoiceDate = null, $dueDate = null, $amount = null, $amountPaid = null, $vATAmount = null, $freightAmount = null, $handlingFee = null, $invoiceNumber = null, $orderNumber = null, \StructType\Order $orderItem = null, $spare01 = null, $spare02 = null, $spare03 = null, $spare04 = null, $spare05 = null, $spare06 = null, $spare07 = null, $spare08 = null, $spare09 = null, $spare10 = null, \StructType\Address $invoiceAddress = null)
    {
        $this
            ->setInvoiceDate($invoiceDate)
            ->setDueDate($dueDate)
            ->setAmount($amount)
            ->setAmountPaid($amountPaid)
            ->setVATAmount($vATAmount)
            ->setFreightAmount($freightAmount)
            ->setHandlingFee($handlingFee)
            ->setInvoiceNumber($invoiceNumber)
            ->setOrderNumber($orderNumber)
            ->setOrderItem($orderItem)
            ->setSpare01($spare01)
            ->setSpare02($spare02)
            ->setSpare03($spare03)
            ->setSpare04($spare04)
            ->setSpare05($spare05)
            ->setSpare06($spare06)
            ->setSpare07($spare07)
            ->setSpare08($spare08)
            ->setSpare09($spare09)
            ->setSpare10($spare10)
            ->setInvoiceAddress($invoiceAddress);
    }
    /**
     * Get InvoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\Invoice
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \StructType\Invoice
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Invoice
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AmountPaid value
     * @return float
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param float $amountPaid
     * @return \StructType\Invoice
     */
    public function setAmountPaid($amountPaid = null)
    {
        // validation for constraint: float
        if (!is_null($amountPaid) && !(is_float($amountPaid) || is_numeric($amountPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountPaid, true), gettype($amountPaid)), __LINE__);
        }
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get VATAmount value
     * @return float
     */
    public function getVATAmount()
    {
        return $this->VATAmount;
    }
    /**
     * Set VATAmount value
     * @param float $vATAmount
     * @return \StructType\Invoice
     */
    public function setVATAmount($vATAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vATAmount) && !(is_float($vATAmount) || is_numeric($vATAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vATAmount, true), gettype($vATAmount)), __LINE__);
        }
        $this->VATAmount = $vATAmount;
        return $this;
    }
    /**
     * Get FreightAmount value
     * @return float
     */
    public function getFreightAmount()
    {
        return $this->FreightAmount;
    }
    /**
     * Set FreightAmount value
     * @param float $freightAmount
     * @return \StructType\Invoice
     */
    public function setFreightAmount($freightAmount = null)
    {
        // validation for constraint: float
        if (!is_null($freightAmount) && !(is_float($freightAmount) || is_numeric($freightAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freightAmount, true), gettype($freightAmount)), __LINE__);
        }
        $this->FreightAmount = $freightAmount;
        return $this;
    }
    /**
     * Get HandlingFee value
     * @return float
     */
    public function getHandlingFee()
    {
        return $this->HandlingFee;
    }
    /**
     * Set HandlingFee value
     * @param float $handlingFee
     * @return \StructType\Invoice
     */
    public function setHandlingFee($handlingFee = null)
    {
        // validation for constraint: float
        if (!is_null($handlingFee) && !(is_float($handlingFee) || is_numeric($handlingFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingFee, true), gettype($handlingFee)), __LINE__);
        }
        $this->HandlingFee = $handlingFee;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\Invoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\Invoice
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get OrderItem value
     * @return \StructType\Order|null
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * Set OrderItem value
     * @param \StructType\Order $orderItem
     * @return \StructType\Invoice
     */
    public function setOrderItem(\StructType\Order $orderItem = null)
    {
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Get Spare01 value
     * @return string|null
     */
    public function getSpare01()
    {
        return $this->Spare01;
    }
    /**
     * Set Spare01 value
     * @param string $spare01
     * @return \StructType\Invoice
     */
    public function setSpare01($spare01 = null)
    {
        // validation for constraint: string
        if (!is_null($spare01) && !is_string($spare01)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare01, true), gettype($spare01)), __LINE__);
        }
        $this->Spare01 = $spare01;
        return $this;
    }
    /**
     * Get Spare02 value
     * @return string|null
     */
    public function getSpare02()
    {
        return $this->Spare02;
    }
    /**
     * Set Spare02 value
     * @param string $spare02
     * @return \StructType\Invoice
     */
    public function setSpare02($spare02 = null)
    {
        // validation for constraint: string
        if (!is_null($spare02) && !is_string($spare02)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare02, true), gettype($spare02)), __LINE__);
        }
        $this->Spare02 = $spare02;
        return $this;
    }
    /**
     * Get Spare03 value
     * @return string|null
     */
    public function getSpare03()
    {
        return $this->Spare03;
    }
    /**
     * Set Spare03 value
     * @param string $spare03
     * @return \StructType\Invoice
     */
    public function setSpare03($spare03 = null)
    {
        // validation for constraint: string
        if (!is_null($spare03) && !is_string($spare03)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare03, true), gettype($spare03)), __LINE__);
        }
        $this->Spare03 = $spare03;
        return $this;
    }
    /**
     * Get Spare04 value
     * @return string|null
     */
    public function getSpare04()
    {
        return $this->Spare04;
    }
    /**
     * Set Spare04 value
     * @param string $spare04
     * @return \StructType\Invoice
     */
    public function setSpare04($spare04 = null)
    {
        // validation for constraint: string
        if (!is_null($spare04) && !is_string($spare04)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare04, true), gettype($spare04)), __LINE__);
        }
        $this->Spare04 = $spare04;
        return $this;
    }
    /**
     * Get Spare05 value
     * @return string|null
     */
    public function getSpare05()
    {
        return $this->Spare05;
    }
    /**
     * Set Spare05 value
     * @param string $spare05
     * @return \StructType\Invoice
     */
    public function setSpare05($spare05 = null)
    {
        // validation for constraint: string
        if (!is_null($spare05) && !is_string($spare05)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare05, true), gettype($spare05)), __LINE__);
        }
        $this->Spare05 = $spare05;
        return $this;
    }
    /**
     * Get Spare06 value
     * @return string|null
     */
    public function getSpare06()
    {
        return $this->Spare06;
    }
    /**
     * Set Spare06 value
     * @param string $spare06
     * @return \StructType\Invoice
     */
    public function setSpare06($spare06 = null)
    {
        // validation for constraint: string
        if (!is_null($spare06) && !is_string($spare06)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare06, true), gettype($spare06)), __LINE__);
        }
        $this->Spare06 = $spare06;
        return $this;
    }
    /**
     * Get Spare07 value
     * @return string|null
     */
    public function getSpare07()
    {
        return $this->Spare07;
    }
    /**
     * Set Spare07 value
     * @param string $spare07
     * @return \StructType\Invoice
     */
    public function setSpare07($spare07 = null)
    {
        // validation for constraint: string
        if (!is_null($spare07) && !is_string($spare07)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare07, true), gettype($spare07)), __LINE__);
        }
        $this->Spare07 = $spare07;
        return $this;
    }
    /**
     * Get Spare08 value
     * @return string|null
     */
    public function getSpare08()
    {
        return $this->Spare08;
    }
    /**
     * Set Spare08 value
     * @param string $spare08
     * @return \StructType\Invoice
     */
    public function setSpare08($spare08 = null)
    {
        // validation for constraint: string
        if (!is_null($spare08) && !is_string($spare08)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare08, true), gettype($spare08)), __LINE__);
        }
        $this->Spare08 = $spare08;
        return $this;
    }
    /**
     * Get Spare09 value
     * @return string|null
     */
    public function getSpare09()
    {
        return $this->Spare09;
    }
    /**
     * Set Spare09 value
     * @param string $spare09
     * @return \StructType\Invoice
     */
    public function setSpare09($spare09 = null)
    {
        // validation for constraint: string
        if (!is_null($spare09) && !is_string($spare09)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare09, true), gettype($spare09)), __LINE__);
        }
        $this->Spare09 = $spare09;
        return $this;
    }
    /**
     * Get Spare10 value
     * @return string|null
     */
    public function getSpare10()
    {
        return $this->Spare10;
    }
    /**
     * Set Spare10 value
     * @param string $spare10
     * @return \StructType\Invoice
     */
    public function setSpare10($spare10 = null)
    {
        // validation for constraint: string
        if (!is_null($spare10) && !is_string($spare10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare10, true), gettype($spare10)), __LINE__);
        }
        $this->Spare10 = $spare10;
        return $this;
    }
    /**
     * Get InvoiceAddress value
     * @return \StructType\Address|null
     */
    public function getInvoiceAddress()
    {
        return $this->InvoiceAddress;
    }
    /**
     * Set InvoiceAddress value
     * @param \StructType\Address $invoiceAddress
     * @return \StructType\Invoice
     */
    public function setInvoiceAddress(\StructType\Address $invoiceAddress = null)
    {
        $this->InvoiceAddress = $invoiceAddress;
        return $this;
    }
}
