<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BidInfoItem StructType
 * @subpackage Structs
 */
class BidInfoItem extends AbstractStructBase
{
    /**
     * The MinQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinQuantity;
    /**
     * The MaxQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxQuantity;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Stockcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Stockcode;
    /**
     * Constructor method for BidInfoItem
     * @uses BidInfoItem::setMinQuantity()
     * @uses BidInfoItem::setMaxQuantity()
     * @uses BidInfoItem::setPrice()
     * @uses BidInfoItem::setStockcode()
     * @param int $minQuantity
     * @param int $maxQuantity
     * @param float $price
     * @param string $stockcode
     */
    public function __construct($minQuantity = null, $maxQuantity = null, $price = null, $stockcode = null)
    {
        $this
            ->setMinQuantity($minQuantity)
            ->setMaxQuantity($maxQuantity)
            ->setPrice($price)
            ->setStockcode($stockcode);
    }
    /**
     * Get MinQuantity value
     * @return int
     */
    public function getMinQuantity()
    {
        return $this->MinQuantity;
    }
    /**
     * Set MinQuantity value
     * @param int $minQuantity
     * @return \StructType\BidInfoItem
     */
    public function setMinQuantity($minQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minQuantity) && !(is_int($minQuantity) || ctype_digit($minQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minQuantity, true), gettype($minQuantity)), __LINE__);
        }
        $this->MinQuantity = $minQuantity;
        return $this;
    }
    /**
     * Get MaxQuantity value
     * @return int
     */
    public function getMaxQuantity()
    {
        return $this->MaxQuantity;
    }
    /**
     * Set MaxQuantity value
     * @param int $maxQuantity
     * @return \StructType\BidInfoItem
     */
    public function setMaxQuantity($maxQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuantity) && !(is_int($maxQuantity) || ctype_digit($maxQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxQuantity, true), gettype($maxQuantity)), __LINE__);
        }
        $this->MaxQuantity = $maxQuantity;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\BidInfoItem
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Stockcode value
     * @return string|null
     */
    public function getStockcode()
    {
        return $this->Stockcode;
    }
    /**
     * Set Stockcode value
     * @param string $stockcode
     * @return \StructType\BidInfoItem
     */
    public function setStockcode($stockcode = null)
    {
        // validation for constraint: string
        if (!is_null($stockcode) && !is_string($stockcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockcode, true), gettype($stockcode)), __LINE__);
        }
        $this->Stockcode = $stockcode;
        return $this;
    }
}
