<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BidInfoHeader StructType
 * @subpackage Structs
 */
class BidInfoHeader extends AbstractStructBase
{
    /**
     * The Stako
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Stako;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBidInfoItem
     */
    public $Items;
    /**
     * Constructor method for BidInfoHeader
     * @uses BidInfoHeader::setStako()
     * @uses BidInfoHeader::setStartDate()
     * @uses BidInfoHeader::setEndDate()
     * @uses BidInfoHeader::setName()
     * @uses BidInfoHeader::setDescription()
     * @uses BidInfoHeader::setCustomerName()
     * @uses BidInfoHeader::setItems()
     * @param bool $stako
     * @param string $startDate
     * @param string $endDate
     * @param string $name
     * @param string $description
     * @param string $customerName
     * @param \ArrayType\ArrayOfBidInfoItem $items
     */
    public function __construct($stako = null, $startDate = null, $endDate = null, $name = null, $description = null, $customerName = null, \ArrayType\ArrayOfBidInfoItem $items = null)
    {
        $this
            ->setStako($stako)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setName($name)
            ->setDescription($description)
            ->setCustomerName($customerName)
            ->setItems($items);
    }
    /**
     * Get Stako value
     * @return bool
     */
    public function getStako()
    {
        return $this->Stako;
    }
    /**
     * Set Stako value
     * @param bool $stako
     * @return \StructType\BidInfoHeader
     */
    public function setStako($stako = null)
    {
        // validation for constraint: boolean
        if (!is_null($stako) && !is_bool($stako)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stako, true), gettype($stako)), __LINE__);
        }
        $this->Stako = $stako;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\BidInfoHeader
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\BidInfoHeader
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\BidInfoHeader
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\BidInfoHeader
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \StructType\BidInfoHeader
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfBidInfoItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfBidInfoItem $items
     * @return \StructType\BidInfoHeader
     */
    public function setItems(\ArrayType\ArrayOfBidInfoItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
}
