<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the SecurityHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SecurityHeader $securityHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurityHeader(\StructType\SecurityHeader $securityHeader, $nameSpace = 'http://www.captech.se/OWS/v4/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SecurityHeader', $securityHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SecurityHeader
     * - SOAPHeaderNamespaces: http://www.captech.se/OWS/v4/
     * - SOAPHeaderTypes: \StructType\SecurityHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrder $parameters
     * @return \StructType\CreateOrderResponse|bool
     */
    public function CreateOrder(\StructType\CreateOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
