<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderListItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderListItem extends AbstractStructArrayBase
{
    /**
     * The OrderListItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderListItem[]
     */
    public $OrderListItem;
    /**
     * Constructor method for ArrayOfOrderListItem
     * @uses ArrayOfOrderListItem::setOrderListItem()
     * @param \StructType\OrderListItem[] $orderListItem
     */
    public function __construct(array $orderListItem = array())
    {
        $this
            ->setOrderListItem($orderListItem);
    }
    /**
     * Get OrderListItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderListItem[]|null
     */
    public function getOrderListItem()
    {
        return isset($this->OrderListItem) ? $this->OrderListItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderListItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderListItemForArrayConstraintsFromSetOrderListItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderListItemOrderListItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderListItemOrderListItemItem instanceof \StructType\OrderListItem) {
                $invalidValues[] = is_object($arrayOfOrderListItemOrderListItemItem) ? get_class($arrayOfOrderListItemOrderListItemItem) : sprintf('%s(%s)', gettype($arrayOfOrderListItemOrderListItemItem), var_export($arrayOfOrderListItemOrderListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderListItem property can only contain items of type \StructType\OrderListItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderListItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderListItem[] $orderListItem
     * @return \ArrayType\ArrayOfOrderListItem
     */
    public function setOrderListItem(array $orderListItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderListItemArrayErrorMessage = self::validateOrderListItemForArrayConstraintsFromSetOrderListItem($orderListItem))) {
            throw new \InvalidArgumentException($orderListItemArrayErrorMessage, __LINE__);
        }
        if (is_null($orderListItem) || (is_array($orderListItem) && empty($orderListItem))) {
            unset($this->OrderListItem);
        } else {
            $this->OrderListItem = $orderListItem;
        }
        return $this;
    }
    /**
     * Add item to OrderListItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderListItem $item
     * @return \ArrayType\ArrayOfOrderListItem
     */
    public function addToOrderListItem(\StructType\OrderListItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderListItem) {
            throw new \InvalidArgumentException(sprintf('The OrderListItem property can only contain items of type \StructType\OrderListItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderListItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderListItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderListItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderListItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderListItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderListItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderListItem
     */
    public function getAttributeName()
    {
        return 'OrderListItem';
    }
}
