<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBatchNumber ArrayType
 * @subpackage Arrays
 */
class ArrayOfBatchNumber extends AbstractStructArrayBase
{
    /**
     * The BatchNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BatchNumber[]
     */
    public $BatchNumber;
    /**
     * Constructor method for ArrayOfBatchNumber
     * @uses ArrayOfBatchNumber::setBatchNumber()
     * @param \StructType\BatchNumber[] $batchNumber
     */
    public function __construct(array $batchNumber = array())
    {
        $this
            ->setBatchNumber($batchNumber);
    }
    /**
     * Get BatchNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BatchNumber[]|null
     */
    public function getBatchNumber()
    {
        return isset($this->BatchNumber) ? $this->BatchNumber : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBatchNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBatchNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBatchNumberForArrayConstraintsFromSetBatchNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBatchNumberBatchNumberItem) {
            // validation for constraint: itemType
            if (!$arrayOfBatchNumberBatchNumberItem instanceof \StructType\BatchNumber) {
                $invalidValues[] = is_object($arrayOfBatchNumberBatchNumberItem) ? get_class($arrayOfBatchNumberBatchNumberItem) : sprintf('%s(%s)', gettype($arrayOfBatchNumberBatchNumberItem), var_export($arrayOfBatchNumberBatchNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BatchNumber property can only contain items of type \StructType\BatchNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BatchNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BatchNumber[] $batchNumber
     * @return \ArrayType\ArrayOfBatchNumber
     */
    public function setBatchNumber(array $batchNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($batchNumberArrayErrorMessage = self::validateBatchNumberForArrayConstraintsFromSetBatchNumber($batchNumber))) {
            throw new \InvalidArgumentException($batchNumberArrayErrorMessage, __LINE__);
        }
        if (is_null($batchNumber) || (is_array($batchNumber) && empty($batchNumber))) {
            unset($this->BatchNumber);
        } else {
            $this->BatchNumber = $batchNumber;
        }
        return $this;
    }
    /**
     * Add item to BatchNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\BatchNumber $item
     * @return \ArrayType\ArrayOfBatchNumber
     */
    public function addToBatchNumber(\StructType\BatchNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BatchNumber) {
            throw new \InvalidArgumentException(sprintf('The BatchNumber property can only contain items of type \StructType\BatchNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BatchNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BatchNumber|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BatchNumber|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BatchNumber|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BatchNumber|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BatchNumber|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BatchNumber
     */
    public function getAttributeName()
    {
        return 'BatchNumber';
    }
}
