<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.exertis.se/WebServices/OrderWebService/OrderWebService_v4.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.exertis.se/WebServices/OrderWebService/OrderWebService_v4.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderSecurityHeader(new \StructType\SecurityHeader());
/**
 * Sample call for GetOrderNumbersByPurchaseOrderNumber operation/method
 */
if ($get->GetOrderNumbersByPurchaseOrderNumber(new \StructType\GetOrderNumbersByPurchaseOrderNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderInfo operation/method
 */
if ($get->GetOrderInfo(new \StructType\GetOrderInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceInfo operation/method
 */
if ($get->GetInvoiceInfo(new \StructType\GetInvoiceInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDailyInvoices operation/method
 */
if ($get->GetDailyInvoices(new \StructType\GetDailyInvoices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBidInfo operation/method
 */
if ($get->GetBidInfo(new \StructType\GetBidInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOpenOrders operation/method
 */
if ($get->GetOpenOrders(new \StructType\GetOpenOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderSecurityHeader(new \StructType\SecurityHeader());
/**
 * Sample call for CreateOrder operation/method
 */
if ($create->CreateOrder(new \StructType\CreateOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
