<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityHeader StructType
 * Meta information extracted from the WSDL
 * - type: tns:SecurityHeader
 * @subpackage Structs
 */
class SecurityHeader extends AbstractStructBase
{
    /**
     * The TestOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TestOrder;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for SecurityHeader
     * @uses SecurityHeader::setTestOrder()
     * @uses SecurityHeader::setCustomerNumber()
     * @uses SecurityHeader::setUsername()
     * @uses SecurityHeader::setPassword()
     * @param bool $testOrder
     * @param string $customerNumber
     * @param string $username
     * @param string $password
     */
    public function __construct($testOrder = null, $customerNumber = null, $username = null, $password = null)
    {
        $this
            ->setTestOrder($testOrder)
            ->setCustomerNumber($customerNumber)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get TestOrder value
     * @return bool
     */
    public function getTestOrder()
    {
        return $this->TestOrder;
    }
    /**
     * Set TestOrder value
     * @param bool $testOrder
     * @return \StructType\SecurityHeader
     */
    public function setTestOrder($testOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($testOrder) && !is_bool($testOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($testOrder, true), gettype($testOrder)), __LINE__);
        }
        $this->TestOrder = $testOrder;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\SecurityHeader
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\SecurityHeader
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\SecurityHeader
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
