<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderLine StructType
 * @subpackage Structs
 */
class OrderLine extends AbstractStructBase
{
    /**
     * The QuantityOrdered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuantityOrdered;
    /**
     * The QuantityDelivered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuantityDelivered;
    /**
     * The QuantityAllocked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuantityAllocked;
    /**
     * The OrderPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OrderPrice;
    /**
     * The CustomerDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CustomerDiscount;
    /**
     * The CustomerPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CustomerPrice;
    /**
     * The PreliminaryEarliestShipDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PreliminaryEarliestShipDate;
    /**
     * The ExpectedUnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExpectedUnitPrice;
    /**
     * The VatPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatPercent;
    /**
     * The Stockcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Stockcode;
    /**
     * The ManufacturerStockcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerStockcode;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The Linenumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Linenumber;
    /**
     * The StructureLineNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StructureLineNumber;
    /**
     * The Stockname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Stockname;
    /**
     * The BidName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BidName;
    /**
     * The WarehouseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseCode;
    /**
     * The Spare01
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare01;
    /**
     * The Spare02
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare02;
    /**
     * The Spare03
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare03;
    /**
     * The Spare04
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare04;
    /**
     * The Spare05
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare05;
    /**
     * The Spare06
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare06;
    /**
     * The Spare07
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare07;
    /**
     * The Spare08
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare08;
    /**
     * The Spare09
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare09;
    /**
     * The Spare10
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spare10;
    /**
     * The BatchNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBatchNumber
     */
    public $BatchNumbers;
    /**
     * Constructor method for OrderLine
     * @uses OrderLine::setQuantityOrdered()
     * @uses OrderLine::setQuantityDelivered()
     * @uses OrderLine::setQuantityAllocked()
     * @uses OrderLine::setOrderPrice()
     * @uses OrderLine::setCustomerDiscount()
     * @uses OrderLine::setCustomerPrice()
     * @uses OrderLine::setPreliminaryEarliestShipDate()
     * @uses OrderLine::setExpectedUnitPrice()
     * @uses OrderLine::setVatPercent()
     * @uses OrderLine::setStockcode()
     * @uses OrderLine::setManufacturerStockcode()
     * @uses OrderLine::setEAN()
     * @uses OrderLine::setLinenumber()
     * @uses OrderLine::setStructureLineNumber()
     * @uses OrderLine::setStockname()
     * @uses OrderLine::setBidName()
     * @uses OrderLine::setWarehouseCode()
     * @uses OrderLine::setSpare01()
     * @uses OrderLine::setSpare02()
     * @uses OrderLine::setSpare03()
     * @uses OrderLine::setSpare04()
     * @uses OrderLine::setSpare05()
     * @uses OrderLine::setSpare06()
     * @uses OrderLine::setSpare07()
     * @uses OrderLine::setSpare08()
     * @uses OrderLine::setSpare09()
     * @uses OrderLine::setSpare10()
     * @uses OrderLine::setBatchNumbers()
     * @param int $quantityOrdered
     * @param int $quantityDelivered
     * @param int $quantityAllocked
     * @param float $orderPrice
     * @param float $customerDiscount
     * @param float $customerPrice
     * @param string $preliminaryEarliestShipDate
     * @param float $expectedUnitPrice
     * @param float $vatPercent
     * @param string $stockcode
     * @param string $manufacturerStockcode
     * @param string $eAN
     * @param string $linenumber
     * @param string $structureLineNumber
     * @param string $stockname
     * @param string $bidName
     * @param string $warehouseCode
     * @param string $spare01
     * @param string $spare02
     * @param string $spare03
     * @param string $spare04
     * @param string $spare05
     * @param string $spare06
     * @param string $spare07
     * @param string $spare08
     * @param string $spare09
     * @param string $spare10
     * @param \ArrayType\ArrayOfBatchNumber $batchNumbers
     */
    public function __construct($quantityOrdered = null, $quantityDelivered = null, $quantityAllocked = null, $orderPrice = null, $customerDiscount = null, $customerPrice = null, $preliminaryEarliestShipDate = null, $expectedUnitPrice = null, $vatPercent = null, $stockcode = null, $manufacturerStockcode = null, $eAN = null, $linenumber = null, $structureLineNumber = null, $stockname = null, $bidName = null, $warehouseCode = null, $spare01 = null, $spare02 = null, $spare03 = null, $spare04 = null, $spare05 = null, $spare06 = null, $spare07 = null, $spare08 = null, $spare09 = null, $spare10 = null, \ArrayType\ArrayOfBatchNumber $batchNumbers = null)
    {
        $this
            ->setQuantityOrdered($quantityOrdered)
            ->setQuantityDelivered($quantityDelivered)
            ->setQuantityAllocked($quantityAllocked)
            ->setOrderPrice($orderPrice)
            ->setCustomerDiscount($customerDiscount)
            ->setCustomerPrice($customerPrice)
            ->setPreliminaryEarliestShipDate($preliminaryEarliestShipDate)
            ->setExpectedUnitPrice($expectedUnitPrice)
            ->setVatPercent($vatPercent)
            ->setStockcode($stockcode)
            ->setManufacturerStockcode($manufacturerStockcode)
            ->setEAN($eAN)
            ->setLinenumber($linenumber)
            ->setStructureLineNumber($structureLineNumber)
            ->setStockname($stockname)
            ->setBidName($bidName)
            ->setWarehouseCode($warehouseCode)
            ->setSpare01($spare01)
            ->setSpare02($spare02)
            ->setSpare03($spare03)
            ->setSpare04($spare04)
            ->setSpare05($spare05)
            ->setSpare06($spare06)
            ->setSpare07($spare07)
            ->setSpare08($spare08)
            ->setSpare09($spare09)
            ->setSpare10($spare10)
            ->setBatchNumbers($batchNumbers);
    }
    /**
     * Get QuantityOrdered value
     * @return int
     */
    public function getQuantityOrdered()
    {
        return $this->QuantityOrdered;
    }
    /**
     * Set QuantityOrdered value
     * @param int $quantityOrdered
     * @return \StructType\OrderLine
     */
    public function setQuantityOrdered($quantityOrdered = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOrdered) && !(is_int($quantityOrdered) || ctype_digit($quantityOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOrdered, true), gettype($quantityOrdered)), __LINE__);
        }
        $this->QuantityOrdered = $quantityOrdered;
        return $this;
    }
    /**
     * Get QuantityDelivered value
     * @return int
     */
    public function getQuantityDelivered()
    {
        return $this->QuantityDelivered;
    }
    /**
     * Set QuantityDelivered value
     * @param int $quantityDelivered
     * @return \StructType\OrderLine
     */
    public function setQuantityDelivered($quantityDelivered = null)
    {
        // validation for constraint: int
        if (!is_null($quantityDelivered) && !(is_int($quantityDelivered) || ctype_digit($quantityDelivered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityDelivered, true), gettype($quantityDelivered)), __LINE__);
        }
        $this->QuantityDelivered = $quantityDelivered;
        return $this;
    }
    /**
     * Get QuantityAllocked value
     * @return int
     */
    public function getQuantityAllocked()
    {
        return $this->QuantityAllocked;
    }
    /**
     * Set QuantityAllocked value
     * @param int $quantityAllocked
     * @return \StructType\OrderLine
     */
    public function setQuantityAllocked($quantityAllocked = null)
    {
        // validation for constraint: int
        if (!is_null($quantityAllocked) && !(is_int($quantityAllocked) || ctype_digit($quantityAllocked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityAllocked, true), gettype($quantityAllocked)), __LINE__);
        }
        $this->QuantityAllocked = $quantityAllocked;
        return $this;
    }
    /**
     * Get OrderPrice value
     * @return float
     */
    public function getOrderPrice()
    {
        return $this->OrderPrice;
    }
    /**
     * Set OrderPrice value
     * @param float $orderPrice
     * @return \StructType\OrderLine
     */
    public function setOrderPrice($orderPrice = null)
    {
        // validation for constraint: float
        if (!is_null($orderPrice) && !(is_float($orderPrice) || is_numeric($orderPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderPrice, true), gettype($orderPrice)), __LINE__);
        }
        $this->OrderPrice = $orderPrice;
        return $this;
    }
    /**
     * Get CustomerDiscount value
     * @return float
     */
    public function getCustomerDiscount()
    {
        return $this->CustomerDiscount;
    }
    /**
     * Set CustomerDiscount value
     * @param float $customerDiscount
     * @return \StructType\OrderLine
     */
    public function setCustomerDiscount($customerDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($customerDiscount) && !(is_float($customerDiscount) || is_numeric($customerDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customerDiscount, true), gettype($customerDiscount)), __LINE__);
        }
        $this->CustomerDiscount = $customerDiscount;
        return $this;
    }
    /**
     * Get CustomerPrice value
     * @return float
     */
    public function getCustomerPrice()
    {
        return $this->CustomerPrice;
    }
    /**
     * Set CustomerPrice value
     * @param float $customerPrice
     * @return \StructType\OrderLine
     */
    public function setCustomerPrice($customerPrice = null)
    {
        // validation for constraint: float
        if (!is_null($customerPrice) && !(is_float($customerPrice) || is_numeric($customerPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customerPrice, true), gettype($customerPrice)), __LINE__);
        }
        $this->CustomerPrice = $customerPrice;
        return $this;
    }
    /**
     * Get PreliminaryEarliestShipDate value
     * @return string
     */
    public function getPreliminaryEarliestShipDate()
    {
        return $this->PreliminaryEarliestShipDate;
    }
    /**
     * Set PreliminaryEarliestShipDate value
     * @param string $preliminaryEarliestShipDate
     * @return \StructType\OrderLine
     */
    public function setPreliminaryEarliestShipDate($preliminaryEarliestShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($preliminaryEarliestShipDate) && !is_string($preliminaryEarliestShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preliminaryEarliestShipDate, true), gettype($preliminaryEarliestShipDate)), __LINE__);
        }
        $this->PreliminaryEarliestShipDate = $preliminaryEarliestShipDate;
        return $this;
    }
    /**
     * Get ExpectedUnitPrice value
     * @return float
     */
    public function getExpectedUnitPrice()
    {
        return $this->ExpectedUnitPrice;
    }
    /**
     * Set ExpectedUnitPrice value
     * @param float $expectedUnitPrice
     * @return \StructType\OrderLine
     */
    public function setExpectedUnitPrice($expectedUnitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($expectedUnitPrice) && !(is_float($expectedUnitPrice) || is_numeric($expectedUnitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedUnitPrice, true), gettype($expectedUnitPrice)), __LINE__);
        }
        $this->ExpectedUnitPrice = $expectedUnitPrice;
        return $this;
    }
    /**
     * Get VatPercent value
     * @return float
     */
    public function getVatPercent()
    {
        return $this->VatPercent;
    }
    /**
     * Set VatPercent value
     * @param float $vatPercent
     * @return \StructType\OrderLine
     */
    public function setVatPercent($vatPercent = null)
    {
        // validation for constraint: float
        if (!is_null($vatPercent) && !(is_float($vatPercent) || is_numeric($vatPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatPercent, true), gettype($vatPercent)), __LINE__);
        }
        $this->VatPercent = $vatPercent;
        return $this;
    }
    /**
     * Get Stockcode value
     * @return string|null
     */
    public function getStockcode()
    {
        return $this->Stockcode;
    }
    /**
     * Set Stockcode value
     * @param string $stockcode
     * @return \StructType\OrderLine
     */
    public function setStockcode($stockcode = null)
    {
        // validation for constraint: string
        if (!is_null($stockcode) && !is_string($stockcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockcode, true), gettype($stockcode)), __LINE__);
        }
        $this->Stockcode = $stockcode;
        return $this;
    }
    /**
     * Get ManufacturerStockcode value
     * @return string|null
     */
    public function getManufacturerStockcode()
    {
        return $this->ManufacturerStockcode;
    }
    /**
     * Set ManufacturerStockcode value
     * @param string $manufacturerStockcode
     * @return \StructType\OrderLine
     */
    public function setManufacturerStockcode($manufacturerStockcode = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerStockcode) && !is_string($manufacturerStockcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerStockcode, true), gettype($manufacturerStockcode)), __LINE__);
        }
        $this->ManufacturerStockcode = $manufacturerStockcode;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\OrderLine
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get Linenumber value
     * @return string|null
     */
    public function getLinenumber()
    {
        return $this->Linenumber;
    }
    /**
     * Set Linenumber value
     * @param string $linenumber
     * @return \StructType\OrderLine
     */
    public function setLinenumber($linenumber = null)
    {
        // validation for constraint: string
        if (!is_null($linenumber) && !is_string($linenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linenumber, true), gettype($linenumber)), __LINE__);
        }
        $this->Linenumber = $linenumber;
        return $this;
    }
    /**
     * Get StructureLineNumber value
     * @return string|null
     */
    public function getStructureLineNumber()
    {
        return $this->StructureLineNumber;
    }
    /**
     * Set StructureLineNumber value
     * @param string $structureLineNumber
     * @return \StructType\OrderLine
     */
    public function setStructureLineNumber($structureLineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($structureLineNumber) && !is_string($structureLineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($structureLineNumber, true), gettype($structureLineNumber)), __LINE__);
        }
        $this->StructureLineNumber = $structureLineNumber;
        return $this;
    }
    /**
     * Get Stockname value
     * @return string|null
     */
    public function getStockname()
    {
        return $this->Stockname;
    }
    /**
     * Set Stockname value
     * @param string $stockname
     * @return \StructType\OrderLine
     */
    public function setStockname($stockname = null)
    {
        // validation for constraint: string
        if (!is_null($stockname) && !is_string($stockname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockname, true), gettype($stockname)), __LINE__);
        }
        $this->Stockname = $stockname;
        return $this;
    }
    /**
     * Get BidName value
     * @return string|null
     */
    public function getBidName()
    {
        return $this->BidName;
    }
    /**
     * Set BidName value
     * @param string $bidName
     * @return \StructType\OrderLine
     */
    public function setBidName($bidName = null)
    {
        // validation for constraint: string
        if (!is_null($bidName) && !is_string($bidName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bidName, true), gettype($bidName)), __LINE__);
        }
        $this->BidName = $bidName;
        return $this;
    }
    /**
     * Get WarehouseCode value
     * @return string|null
     */
    public function getWarehouseCode()
    {
        return $this->WarehouseCode;
    }
    /**
     * Set WarehouseCode value
     * @param string $warehouseCode
     * @return \StructType\OrderLine
     */
    public function setWarehouseCode($warehouseCode = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseCode) && !is_string($warehouseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseCode, true), gettype($warehouseCode)), __LINE__);
        }
        $this->WarehouseCode = $warehouseCode;
        return $this;
    }
    /**
     * Get Spare01 value
     * @return string|null
     */
    public function getSpare01()
    {
        return $this->Spare01;
    }
    /**
     * Set Spare01 value
     * @param string $spare01
     * @return \StructType\OrderLine
     */
    public function setSpare01($spare01 = null)
    {
        // validation for constraint: string
        if (!is_null($spare01) && !is_string($spare01)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare01, true), gettype($spare01)), __LINE__);
        }
        $this->Spare01 = $spare01;
        return $this;
    }
    /**
     * Get Spare02 value
     * @return string|null
     */
    public function getSpare02()
    {
        return $this->Spare02;
    }
    /**
     * Set Spare02 value
     * @param string $spare02
     * @return \StructType\OrderLine
     */
    public function setSpare02($spare02 = null)
    {
        // validation for constraint: string
        if (!is_null($spare02) && !is_string($spare02)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare02, true), gettype($spare02)), __LINE__);
        }
        $this->Spare02 = $spare02;
        return $this;
    }
    /**
     * Get Spare03 value
     * @return string|null
     */
    public function getSpare03()
    {
        return $this->Spare03;
    }
    /**
     * Set Spare03 value
     * @param string $spare03
     * @return \StructType\OrderLine
     */
    public function setSpare03($spare03 = null)
    {
        // validation for constraint: string
        if (!is_null($spare03) && !is_string($spare03)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare03, true), gettype($spare03)), __LINE__);
        }
        $this->Spare03 = $spare03;
        return $this;
    }
    /**
     * Get Spare04 value
     * @return string|null
     */
    public function getSpare04()
    {
        return $this->Spare04;
    }
    /**
     * Set Spare04 value
     * @param string $spare04
     * @return \StructType\OrderLine
     */
    public function setSpare04($spare04 = null)
    {
        // validation for constraint: string
        if (!is_null($spare04) && !is_string($spare04)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare04, true), gettype($spare04)), __LINE__);
        }
        $this->Spare04 = $spare04;
        return $this;
    }
    /**
     * Get Spare05 value
     * @return string|null
     */
    public function getSpare05()
    {
        return $this->Spare05;
    }
    /**
     * Set Spare05 value
     * @param string $spare05
     * @return \StructType\OrderLine
     */
    public function setSpare05($spare05 = null)
    {
        // validation for constraint: string
        if (!is_null($spare05) && !is_string($spare05)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare05, true), gettype($spare05)), __LINE__);
        }
        $this->Spare05 = $spare05;
        return $this;
    }
    /**
     * Get Spare06 value
     * @return string|null
     */
    public function getSpare06()
    {
        return $this->Spare06;
    }
    /**
     * Set Spare06 value
     * @param string $spare06
     * @return \StructType\OrderLine
     */
    public function setSpare06($spare06 = null)
    {
        // validation for constraint: string
        if (!is_null($spare06) && !is_string($spare06)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare06, true), gettype($spare06)), __LINE__);
        }
        $this->Spare06 = $spare06;
        return $this;
    }
    /**
     * Get Spare07 value
     * @return string|null
     */
    public function getSpare07()
    {
        return $this->Spare07;
    }
    /**
     * Set Spare07 value
     * @param string $spare07
     * @return \StructType\OrderLine
     */
    public function setSpare07($spare07 = null)
    {
        // validation for constraint: string
        if (!is_null($spare07) && !is_string($spare07)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare07, true), gettype($spare07)), __LINE__);
        }
        $this->Spare07 = $spare07;
        return $this;
    }
    /**
     * Get Spare08 value
     * @return string|null
     */
    public function getSpare08()
    {
        return $this->Spare08;
    }
    /**
     * Set Spare08 value
     * @param string $spare08
     * @return \StructType\OrderLine
     */
    public function setSpare08($spare08 = null)
    {
        // validation for constraint: string
        if (!is_null($spare08) && !is_string($spare08)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare08, true), gettype($spare08)), __LINE__);
        }
        $this->Spare08 = $spare08;
        return $this;
    }
    /**
     * Get Spare09 value
     * @return string|null
     */
    public function getSpare09()
    {
        return $this->Spare09;
    }
    /**
     * Set Spare09 value
     * @param string $spare09
     * @return \StructType\OrderLine
     */
    public function setSpare09($spare09 = null)
    {
        // validation for constraint: string
        if (!is_null($spare09) && !is_string($spare09)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare09, true), gettype($spare09)), __LINE__);
        }
        $this->Spare09 = $spare09;
        return $this;
    }
    /**
     * Get Spare10 value
     * @return string|null
     */
    public function getSpare10()
    {
        return $this->Spare10;
    }
    /**
     * Set Spare10 value
     * @param string $spare10
     * @return \StructType\OrderLine
     */
    public function setSpare10($spare10 = null)
    {
        // validation for constraint: string
        if (!is_null($spare10) && !is_string($spare10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spare10, true), gettype($spare10)), __LINE__);
        }
        $this->Spare10 = $spare10;
        return $this;
    }
    /**
     * Get BatchNumbers value
     * @return \ArrayType\ArrayOfBatchNumber|null
     */
    public function getBatchNumbers()
    {
        return $this->BatchNumbers;
    }
    /**
     * Set BatchNumbers value
     * @param \ArrayType\ArrayOfBatchNumber $batchNumbers
     * @return \StructType\OrderLine
     */
    public function setBatchNumbers(\ArrayType\ArrayOfBatchNumber $batchNumbers = null)
    {
        $this->BatchNumbers = $batchNumbers;
        return $this;
    }
}
