<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DailyInvoices StructType
 * @subpackage Structs
 */
class DailyInvoices extends ReturnTemplateObject
{
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDate;
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Invoices;
    /**
     * Constructor method for DailyInvoices
     * @uses DailyInvoices::setInvoiceDate()
     * @uses DailyInvoices::setInvoices()
     * @param string $invoiceDate
     * @param \ArrayType\ArrayOfString $invoices
     */
    public function __construct($invoiceDate = null, \ArrayType\ArrayOfString $invoices = null)
    {
        $this
            ->setInvoiceDate($invoiceDate)
            ->setInvoices($invoices);
    }
    /**
     * Get InvoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\DailyInvoices
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get Invoices value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getInvoices()
    {
        return $this->Invoices;
    }
    /**
     * Set Invoices value
     * @param \ArrayType\ArrayOfString $invoices
     * @return \StructType\DailyInvoices
     */
    public function setInvoices(\ArrayType\ArrayOfString $invoices = null)
    {
        $this->Invoices = $invoices;
        return $this;
    }
}
