<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BidInfoObject StructType
 * @subpackage Structs
 */
class BidInfoObject extends ReturnTemplateObject
{
    /**
     * The GenerateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GenerateDate;
    /**
     * The Headers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBidInfoHeader
     */
    public $Headers;
    /**
     * Constructor method for BidInfoObject
     * @uses BidInfoObject::setGenerateDate()
     * @uses BidInfoObject::setHeaders()
     * @param string $generateDate
     * @param \ArrayType\ArrayOfBidInfoHeader $headers
     */
    public function __construct($generateDate = null, \ArrayType\ArrayOfBidInfoHeader $headers = null)
    {
        $this
            ->setGenerateDate($generateDate)
            ->setHeaders($headers);
    }
    /**
     * Get GenerateDate value
     * @return string
     */
    public function getGenerateDate()
    {
        return $this->GenerateDate;
    }
    /**
     * Set GenerateDate value
     * @param string $generateDate
     * @return \StructType\BidInfoObject
     */
    public function setGenerateDate($generateDate = null)
    {
        // validation for constraint: string
        if (!is_null($generateDate) && !is_string($generateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generateDate, true), gettype($generateDate)), __LINE__);
        }
        $this->GenerateDate = $generateDate;
        return $this;
    }
    /**
     * Get Headers value
     * @return \ArrayType\ArrayOfBidInfoHeader|null
     */
    public function getHeaders()
    {
        return $this->Headers;
    }
    /**
     * Set Headers value
     * @param \ArrayType\ArrayOfBidInfoHeader $headers
     * @return \StructType\BidInfoObject
     */
    public function setHeaders(\ArrayType\ArrayOfBidInfoHeader $headers = null)
    {
        $this->Headers = $headers;
        return $this;
    }
}
