<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchNumber StructType
 * @subpackage Structs
 */
class BatchNumber extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The BatchNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchNumber;
    /**
     * The SerialNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $SerialNumbers;
    /**
     * Constructor method for BatchNumber
     * @uses BatchNumber::setQuantity()
     * @uses BatchNumber::setBatchNumber()
     * @uses BatchNumber::setSerialNumbers()
     * @param int $quantity
     * @param string $batchNumber
     * @param \ArrayType\ArrayOfString $serialNumbers
     */
    public function __construct($quantity = null, $batchNumber = null, \ArrayType\ArrayOfString $serialNumbers = null)
    {
        $this
            ->setQuantity($quantity)
            ->setBatchNumber($batchNumber)
            ->setSerialNumbers($serialNumbers);
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\BatchNumber
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get BatchNumber value
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->BatchNumber;
    }
    /**
     * Set BatchNumber value
     * @param string $batchNumber
     * @return \StructType\BatchNumber
     */
    public function setBatchNumber($batchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($batchNumber) && !is_string($batchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchNumber, true), gettype($batchNumber)), __LINE__);
        }
        $this->BatchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get SerialNumbers value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getSerialNumbers()
    {
        return $this->SerialNumbers;
    }
    /**
     * Set SerialNumbers value
     * @param \ArrayType\ArrayOfString $serialNumbers
     * @return \StructType\BatchNumber
     */
    public function setSerialNumbers(\ArrayType\ArrayOfString $serialNumbers = null)
    {
        $this->SerialNumbers = $serialNumbers;
        return $this;
    }
}
