<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the SecurityHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SecurityHeader $securityHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurityHeader(\StructType\SecurityHeader $securityHeader, $nameSpace = 'http://www.captech.se/OWS/v4/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SecurityHeader', $securityHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * GetOrderNumbersByPurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SecurityHeader
     * - SOAPHeaderNamespaces: http://www.captech.se/OWS/v4/
     * - SOAPHeaderTypes: \StructType\SecurityHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderNumbersByPurchaseOrderNumber $parameters
     * @return \StructType\GetOrderNumbersByPurchaseOrderNumberResponse|bool
     */
    public function GetOrderNumbersByPurchaseOrderNumber(\StructType\GetOrderNumbersByPurchaseOrderNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderNumbersByPurchaseOrderNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SecurityHeader
     * - SOAPHeaderNamespaces: http://www.captech.se/OWS/v4/
     * - SOAPHeaderTypes: \StructType\SecurityHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderInfo $parameters
     * @return \StructType\GetOrderInfoResponse|bool
     */
    public function GetOrderInfo(\StructType\GetOrderInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SecurityHeader
     * - SOAPHeaderNamespaces: http://www.captech.se/OWS/v4/
     * - SOAPHeaderTypes: \StructType\SecurityHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceInfo $parameters
     * @return \StructType\GetInvoiceInfoResponse|bool
     */
    public function GetInvoiceInfo(\StructType\GetInvoiceInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDailyInvoices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SecurityHeader
     * - SOAPHeaderNamespaces: http://www.captech.se/OWS/v4/
     * - SOAPHeaderTypes: \StructType\SecurityHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDailyInvoices $parameters
     * @return \StructType\GetDailyInvoicesResponse|bool
     */
    public function GetDailyInvoices(\StructType\GetDailyInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDailyInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBidInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SecurityHeader
     * - SOAPHeaderNamespaces: http://www.captech.se/OWS/v4/
     * - SOAPHeaderTypes: \StructType\SecurityHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBidInfo $parameters
     * @return \StructType\GetBidInfoResponse|bool
     */
    public function GetBidInfo(\StructType\GetBidInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBidInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpenOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SecurityHeader
     * - SOAPHeaderNamespaces: http://www.captech.se/OWS/v4/
     * - SOAPHeaderTypes: \StructType\SecurityHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOpenOrders $parameters
     * @return \StructType\GetOpenOrdersResponse|bool
     */
    public function GetOpenOrders(\StructType\GetOpenOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOpenOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBidInfoResponse|\StructType\GetDailyInvoicesResponse|\StructType\GetInvoiceInfoResponse|\StructType\GetOpenOrdersResponse|\StructType\GetOrderInfoResponse|\StructType\GetOrderNumbersByPurchaseOrderNumberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
