<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for WayOfDeliveryEnum EnumType
 * @subpackage Enumerations
 */
class WayOfDeliveryEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DefaultWayOfDelivery'
     * @return string 'DefaultWayOfDelivery'
     */
    const VALUE_DEFAULT_WAY_OF_DELIVERY = 'DefaultWayOfDelivery';
    /**
     * Constant for value 'PickUp'
     * @return string 'PickUp'
     */
    const VALUE_PICK_UP = 'PickUp';
    /**
     * Constant for value 'DomesticParcelPost'
     * @return string 'DomesticParcelPost'
     */
    const VALUE_DOMESTIC_PARCEL_POST = 'DomesticParcelPost';
    /**
     * Constant for value 'DPDBusinessParcel'
     * @return string 'DPDBusinessParcel'
     */
    const VALUE_DPDBUSINESS_PARCEL = 'DPDBusinessParcel';
    /**
     * Constant for value 'HomeParcel'
     * @return string 'HomeParcel'
     */
    const VALUE_HOME_PARCEL = 'HomeParcel';
    /**
     * Constant for value 'InternationalDPDBusinesParcel'
     * @return string 'InternationalDPDBusinesParcel'
     */
    const VALUE_INTERNATIONAL_DPDBUSINES_PARCEL = 'InternationalDPDBusinesParcel';
    /**
     * Constant for value 'Courier'
     * @return string 'Courier'
     */
    const VALUE_COURIER = 'Courier';
    /**
     * Constant for value 'Mail'
     * @return string 'Mail'
     */
    const VALUE_MAIL = 'Mail';
    /**
     * Constant for value 'BringPickupParcelBulk'
     * @return string 'BringPickupParcelBulk'
     */
    const VALUE_BRING_PICKUP_PARCEL_BULK = 'BringPickupParcelBulk';
    /**
     * Constant for value 'BringBusinessParcelBulk'
     * @return string 'BringBusinessParcelBulk'
     */
    const VALUE_BRING_BUSINESS_PARCEL_BULK = 'BringBusinessParcelBulk';
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT_WAY_OF_DELIVERY
     * @uses self::VALUE_PICK_UP
     * @uses self::VALUE_DOMESTIC_PARCEL_POST
     * @uses self::VALUE_DPDBUSINESS_PARCEL
     * @uses self::VALUE_HOME_PARCEL
     * @uses self::VALUE_INTERNATIONAL_DPDBUSINES_PARCEL
     * @uses self::VALUE_COURIER
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_BRING_PICKUP_PARCEL_BULK
     * @uses self::VALUE_BRING_BUSINESS_PARCEL_BULK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT_WAY_OF_DELIVERY,
            self::VALUE_PICK_UP,
            self::VALUE_DOMESTIC_PARCEL_POST,
            self::VALUE_DPDBUSINESS_PARCEL,
            self::VALUE_HOME_PARCEL,
            self::VALUE_INTERNATIONAL_DPDBUSINES_PARCEL,
            self::VALUE_COURIER,
            self::VALUE_MAIL,
            self::VALUE_BRING_PICKUP_PARCEL_BULK,
            self::VALUE_BRING_BUSINESS_PARCEL_BULK,
        );
    }
}
