<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBidInfoItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfBidInfoItem extends AbstractStructArrayBase
{
    /**
     * The BidInfoItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BidInfoItem[]
     */
    public $BidInfoItem;
    /**
     * Constructor method for ArrayOfBidInfoItem
     * @uses ArrayOfBidInfoItem::setBidInfoItem()
     * @param \StructType\BidInfoItem[] $bidInfoItem
     */
    public function __construct(array $bidInfoItem = array())
    {
        $this
            ->setBidInfoItem($bidInfoItem);
    }
    /**
     * Get BidInfoItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BidInfoItem[]|null
     */
    public function getBidInfoItem()
    {
        return isset($this->BidInfoItem) ? $this->BidInfoItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBidInfoItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBidInfoItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBidInfoItemForArrayConstraintsFromSetBidInfoItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBidInfoItemBidInfoItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfBidInfoItemBidInfoItemItem instanceof \StructType\BidInfoItem) {
                $invalidValues[] = is_object($arrayOfBidInfoItemBidInfoItemItem) ? get_class($arrayOfBidInfoItemBidInfoItemItem) : sprintf('%s(%s)', gettype($arrayOfBidInfoItemBidInfoItemItem), var_export($arrayOfBidInfoItemBidInfoItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BidInfoItem property can only contain items of type \StructType\BidInfoItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BidInfoItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BidInfoItem[] $bidInfoItem
     * @return \ArrayType\ArrayOfBidInfoItem
     */
    public function setBidInfoItem(array $bidInfoItem = array())
    {
        // validation for constraint: array
        if ('' !== ($bidInfoItemArrayErrorMessage = self::validateBidInfoItemForArrayConstraintsFromSetBidInfoItem($bidInfoItem))) {
            throw new \InvalidArgumentException($bidInfoItemArrayErrorMessage, __LINE__);
        }
        if (is_null($bidInfoItem) || (is_array($bidInfoItem) && empty($bidInfoItem))) {
            unset($this->BidInfoItem);
        } else {
            $this->BidInfoItem = $bidInfoItem;
        }
        return $this;
    }
    /**
     * Add item to BidInfoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\BidInfoItem $item
     * @return \ArrayType\ArrayOfBidInfoItem
     */
    public function addToBidInfoItem(\StructType\BidInfoItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BidInfoItem) {
            throw new \InvalidArgumentException(sprintf('The BidInfoItem property can only contain items of type \StructType\BidInfoItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BidInfoItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BidInfoItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BidInfoItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BidInfoItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BidInfoItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BidInfoItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BidInfoItem
     */
    public function getAttributeName()
    {
        return 'BidInfoItem';
    }
}
