<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBidInfoHeader ArrayType
 * @subpackage Arrays
 */
class ArrayOfBidInfoHeader extends AbstractStructArrayBase
{
    /**
     * The BidInfoHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BidInfoHeader[]
     */
    public $BidInfoHeader;
    /**
     * Constructor method for ArrayOfBidInfoHeader
     * @uses ArrayOfBidInfoHeader::setBidInfoHeader()
     * @param \StructType\BidInfoHeader[] $bidInfoHeader
     */
    public function __construct(array $bidInfoHeader = array())
    {
        $this
            ->setBidInfoHeader($bidInfoHeader);
    }
    /**
     * Get BidInfoHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BidInfoHeader[]|null
     */
    public function getBidInfoHeader()
    {
        return isset($this->BidInfoHeader) ? $this->BidInfoHeader : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBidInfoHeader method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBidInfoHeader method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBidInfoHeaderForArrayConstraintsFromSetBidInfoHeader(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBidInfoHeaderBidInfoHeaderItem) {
            // validation for constraint: itemType
            if (!$arrayOfBidInfoHeaderBidInfoHeaderItem instanceof \StructType\BidInfoHeader) {
                $invalidValues[] = is_object($arrayOfBidInfoHeaderBidInfoHeaderItem) ? get_class($arrayOfBidInfoHeaderBidInfoHeaderItem) : sprintf('%s(%s)', gettype($arrayOfBidInfoHeaderBidInfoHeaderItem), var_export($arrayOfBidInfoHeaderBidInfoHeaderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BidInfoHeader property can only contain items of type \StructType\BidInfoHeader, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BidInfoHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BidInfoHeader[] $bidInfoHeader
     * @return \ArrayType\ArrayOfBidInfoHeader
     */
    public function setBidInfoHeader(array $bidInfoHeader = array())
    {
        // validation for constraint: array
        if ('' !== ($bidInfoHeaderArrayErrorMessage = self::validateBidInfoHeaderForArrayConstraintsFromSetBidInfoHeader($bidInfoHeader))) {
            throw new \InvalidArgumentException($bidInfoHeaderArrayErrorMessage, __LINE__);
        }
        if (is_null($bidInfoHeader) || (is_array($bidInfoHeader) && empty($bidInfoHeader))) {
            unset($this->BidInfoHeader);
        } else {
            $this->BidInfoHeader = $bidInfoHeader;
        }
        return $this;
    }
    /**
     * Add item to BidInfoHeader value
     * @throws \InvalidArgumentException
     * @param \StructType\BidInfoHeader $item
     * @return \ArrayType\ArrayOfBidInfoHeader
     */
    public function addToBidInfoHeader(\StructType\BidInfoHeader $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BidInfoHeader) {
            throw new \InvalidArgumentException(sprintf('The BidInfoHeader property can only contain items of type \StructType\BidInfoHeader, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BidInfoHeader[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BidInfoHeader|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BidInfoHeader|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BidInfoHeader|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BidInfoHeader|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BidInfoHeader|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BidInfoHeader
     */
    public function getAttributeName()
    {
        return 'BidInfoHeader';
    }
}
