<?php

namespace Canpar\Ship;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'getManifest' => '\\Canpar\\Ship\\StructType\\GetManifest',
            'getManifestResponse' => '\\Canpar\\Ship\\StructType\\GetManifestResponse',
            'getVersionResponse' => '\\Canpar\\Ship\\StructType\\GetVersionResponse',
            'getLabels' => '\\Canpar\\Ship\\StructType\\GetLabels',
            'getLabelsResponse' => '\\Canpar\\Ship\\StructType\\GetLabelsResponse',
            'getUser' => '\\Canpar\\Ship\\StructType\\GetUser',
            'getUserResponse' => '\\Canpar\\Ship\\StructType\\GetUserResponse',
            'getProforma' => '\\Canpar\\Ship\\StructType\\GetProforma',
            'getProformaResponse' => '\\Canpar\\Ship\\StructType\\GetProformaResponse',
            'unvoidShipment' => '\\Canpar\\Ship\\StructType\\UnvoidShipment',
            'unvoidShipmentResponse' => '\\Canpar\\Ship\\StructType\\UnvoidShipmentResponse',
            'endOfDay' => '\\Canpar\\Ship\\StructType\\EndOfDay',
            'endOfDayResponse' => '\\Canpar\\Ship\\StructType\\EndOfDayResponse',
            'getPreferences' => '\\Canpar\\Ship\\StructType\\GetPreferences',
            'getPreferencesResponse' => '\\Canpar\\Ship\\StructType\\GetPreferencesResponse',
            'saveUser' => '\\Canpar\\Ship\\StructType\\SaveUser',
            'saveUserResponse' => '\\Canpar\\Ship\\StructType\\SaveUserResponse',
            'deleteBox' => '\\Canpar\\Ship\\StructType\\DeleteBox',
            'deleteBoxResponse' => '\\Canpar\\Ship\\StructType\\DeleteBoxResponse',
            'deleteUser' => '\\Canpar\\Ship\\StructType\\DeleteUser',
            'deleteUserResponse' => '\\Canpar\\Ship\\StructType\\DeleteUserResponse',
            'holdShipment' => '\\Canpar\\Ship\\StructType\\HoldShipment',
            'holdShipmentResponse' => '\\Canpar\\Ship\\StructType\\HoldShipmentResponse',
            'deleteCostCentre' => '\\Canpar\\Ship\\StructType\\DeleteCostCentre',
            'deleteCostCentreResponse' => '\\Canpar\\Ship\\StructType\\DeleteCostCentreResponse',
            'getSTOs' => '\\Canpar\\Ship\\StructType\\GetSTOs',
            'getSTOsResponse' => '\\Canpar\\Ship\\StructType\\GetSTOsResponse',
            'saveBox' => '\\Canpar\\Ship\\StructType\\SaveBox',
            'saveBoxResponse' => '\\Canpar\\Ship\\StructType\\SaveBoxResponse',
            'processShipment' => '\\Canpar\\Ship\\StructType\\ProcessShipment',
            'processShipmentResponse' => '\\Canpar\\Ship\\StructType\\ProcessShipmentResponse',
            'getCostCentres' => '\\Canpar\\Ship\\StructType\\GetCostCentres',
            'getCostCentresResponse' => '\\Canpar\\Ship\\StructType\\GetCostCentresResponse',
            'getCommodities' => '\\Canpar\\Ship\\StructType\\GetCommodities',
            'getCommoditiesResponse' => '\\Canpar\\Ship\\StructType\\GetCommoditiesResponse',
            'deleteSTO' => '\\Canpar\\Ship\\StructType\\DeleteSTO',
            'deleteSTOResponse' => '\\Canpar\\Ship\\StructType\\DeleteSTOResponse',
            'saveSTO' => '\\Canpar\\Ship\\StructType\\SaveSTO',
            'saveSTOResponse' => '\\Canpar\\Ship\\StructType\\SaveSTOResponse',
            'voidShipment' => '\\Canpar\\Ship\\StructType\\VoidShipment',
            'voidShipmentResponse' => '\\Canpar\\Ship\\StructType\\VoidShipmentResponse',
            'saveCommodity' => '\\Canpar\\Ship\\StructType\\SaveCommodity',
            'saveCommodityResponse' => '\\Canpar\\Ship\\StructType\\SaveCommodityResponse',
            'getBoxes' => '\\Canpar\\Ship\\StructType\\GetBoxes',
            'getBoxesResponse' => '\\Canpar\\Ship\\StructType\\GetBoxesResponse',
            'saveAddressBook' => '\\Canpar\\Ship\\StructType\\SaveAddressBook',
            'saveAddressBookResponse' => '\\Canpar\\Ship\\StructType\\SaveAddressBookResponse',
            'saveCostCentre' => '\\Canpar\\Ship\\StructType\\SaveCostCentre',
            'saveCostCentreResponse' => '\\Canpar\\Ship\\StructType\\SaveCostCentreResponse',
            'savePreference' => '\\Canpar\\Ship\\StructType\\SavePreference',
            'savePreferenceResponse' => '\\Canpar\\Ship\\StructType\\SavePreferenceResponse',
            'deleteCommodity' => '\\Canpar\\Ship\\StructType\\DeleteCommodity',
            'deleteCommodityResponse' => '\\Canpar\\Ship\\StructType\\DeleteCommodityResponse',
            'deletePreference' => '\\Canpar\\Ship\\StructType\\DeletePreference',
            'deletePreferenceResponse' => '\\Canpar\\Ship\\StructType\\DeletePreferenceResponse',
            'saveProforma' => '\\Canpar\\Ship\\StructType\\SaveProforma',
            'saveProformaResponse' => '\\Canpar\\Ship\\StructType\\SaveProformaResponse',
            'autorating' => '\\Canpar\\Ship\\StructType\\Autorating',
            'autoratingResponse' => '\\Canpar\\Ship\\StructType\\AutoratingResponse',
            'exportBoxes' => '\\Canpar\\Ship\\StructType\\ExportBoxes',
            'exportBoxesResponse' => '\\Canpar\\Ship\\StructType\\ExportBoxesResponse',
            'deleteProforma' => '\\Canpar\\Ship\\StructType\\DeleteProforma',
            'deleteProformaResponse' => '\\Canpar\\Ship\\StructType\\DeleteProformaResponse',
            'getFuels' => '\\Canpar\\Ship\\StructType\\GetFuels',
            'getFuelsResponse' => '\\Canpar\\Ship\\StructType\\GetFuelsResponse',
            'saveFuel' => '\\Canpar\\Ship\\StructType\\SaveFuel',
            'saveFuelResponse' => '\\Canpar\\Ship\\StructType\\SaveFuelResponse',
            'importBoxes' => '\\Canpar\\Ship\\StructType\\ImportBoxes',
            'importBoxesResponse' => '\\Canpar\\Ship\\StructType\\ImportBoxesResponse',
            'changePassword' => '\\Canpar\\Ship\\StructType\\ChangePassword',
            'changePasswordResponse' => '\\Canpar\\Ship\\StructType\\ChangePasswordResponse',
            'getUsers' => '\\Canpar\\Ship\\StructType\\GetUsers',
            'getUsersResponse' => '\\Canpar\\Ship\\StructType\\GetUsersResponse',
            'searchShipmentsByDeliveryAddressId' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddressId',
            'searchShipmentsByDeliveryAddressIdResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddressIdResponse',
            'searchShipmentsByDeliveryPostalCode' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryPostalCode',
            'searchShipmentsByDeliveryPostalCodeResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryPostalCodeResponse',
            'searchShipmentsByAlternativeReference' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByAlternativeReference',
            'searchShipmentsByAlternativeReferenceResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByAlternativeReferenceResponse',
            'searchShipmentsByDeliveryProvince' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryProvince',
            'searchShipmentsByDeliveryProvinceResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryProvinceResponse',
            'searchAddressBookByProvince' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByProvince',
            'searchAddressBookByProvinceResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByProvinceResponse',
            'getShipmentsAfterDay' => '\\Canpar\\Ship\\StructType\\GetShipmentsAfterDay',
            'getShipmentsAfterDayResponse' => '\\Canpar\\Ship\\StructType\\GetShipmentsAfterDayResponse',
            'searchAddressBookByPostalCode' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPostalCode',
            'searchAddressBookByPostalCodeResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPostalCodeResponse',
            'savePreferenceAllShippers' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllShippers',
            'savePreferenceAllShippersResponse' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllShippersResponse',
            'searchAddressBookByAddressId' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByAddressId',
            'searchAddressBookByAddressIdResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByAddressIdResponse',
            'importAddressBook' => '\\Canpar\\Ship\\StructType\\ImportAddressBook',
            'importAddressBookResponse' => '\\Canpar\\Ship\\StructType\\ImportAddressBookResponse',
            'getLastManifestNumber' => '\\Canpar\\Ship\\StructType\\GetLastManifestNumber',
            'getLastManifestNumberResponse' => '\\Canpar\\Ship\\StructType\\GetLastManifestNumberResponse',
            'searchAddressByPhone' => '\\Canpar\\Ship\\StructType\\SearchAddressByPhone',
            'searchAddressByPhoneResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressByPhoneResponse',
            'importCommodities' => '\\Canpar\\Ship\\StructType\\ImportCommodities',
            'importCommoditiesResponse' => '\\Canpar\\Ship\\StructType\\ImportCommoditiesResponse',
            'saveGlobalPreference' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreference',
            'saveGlobalPreferenceResponse' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreferenceResponse',
            'searchShipmentsByDeliveryName' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryName',
            'searchShipmentsByDeliveryNameResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryNameResponse',
            'getGlobalPreference' => '\\Canpar\\Ship\\StructType\\GetGlobalPreference',
            'getGlobalPreferenceResponse' => '\\Canpar\\Ship\\StructType\\GetGlobalPreferenceResponse',
            'deleteGlobalPreference' => '\\Canpar\\Ship\\StructType\\DeleteGlobalPreference',
            'deleteGlobalPreferenceResponse' => '\\Canpar\\Ship\\StructType\\DeleteGlobalPreferenceResponse',
            'searchAddressBookByCostCentre' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCostCentre',
            'searchAddressBookByCostCentreResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCostCentreResponse',
            'searchShipmentsByDeliveryCity' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryCity',
            'searchShipmentsByDeliveryCityResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryCityResponse',
            'searchShipmentsByOrderId' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByOrderId',
            'searchShipmentsByOrderIdResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByOrderIdResponse',
            'searchShipmentsByShippingDate' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByShippingDate',
            'searchShipmentsByShippingDateResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByShippingDateResponse',
            'importCostCentres' => '\\Canpar\\Ship\\StructType\\ImportCostCentres',
            'importCostCentresResponse' => '\\Canpar\\Ship\\StructType\\ImportCostCentresResponse',
            'searchShipmentsByReference' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByReference',
            'searchShipmentsByReferenceResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByReferenceResponse',
            'exportCostCentres' => '\\Canpar\\Ship\\StructType\\ExportCostCentres',
            'exportCostCentresResponse' => '\\Canpar\\Ship\\StructType\\ExportCostCentresResponse',
            'saveGlobalPreferenceAllUsers' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreferenceAllUsers',
            'saveGlobalPreferenceAllUsersResponse' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreferenceAllUsersResponse',
            'getLabelsAdvanced' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvanced',
            'getLabelsAdvancedResponse' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvancedResponse',
            'deleteAddressBook' => '\\Canpar\\Ship\\StructType\\DeleteAddressBook',
            'deleteAddressBookResponse' => '\\Canpar\\Ship\\StructType\\DeleteAddressBookResponse',
            'searchShipmentsByBarcode' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByBarcode',
            'searchShipmentsByBarcodeResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByBarcodeResponse',
            'searchShipmentsByManifestNum' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByManifestNum',
            'searchShipmentsByManifestNumResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByManifestNumResponse',
            'getConsolidatedProforma' => '\\Canpar\\Ship\\StructType\\GetConsolidatedProforma',
            'getConsolidatedProformaResponse' => '\\Canpar\\Ship\\StructType\\GetConsolidatedProformaResponse',
            'searchShipmentsByDeliveryAddress' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddress',
            'searchShipmentsByDeliveryAddressResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddressResponse',
            'getShipmentsBeforeDay' => '\\Canpar\\Ship\\StructType\\GetShipmentsBeforeDay',
            'getShipmentsBeforeDayResponse' => '\\Canpar\\Ship\\StructType\\GetShipmentsBeforeDayResponse',
            'searchAddressBookByName' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByName',
            'searchAddressBookByNameResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByNameResponse',
            'exportAddressBook' => '\\Canpar\\Ship\\StructType\\ExportAddressBook',
            'exportAddressBookResponse' => '\\Canpar\\Ship\\StructType\\ExportAddressBookResponse',
            'savePreferenceAllUsers' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllUsers',
            'savePreferenceAllUsersResponse' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllUsersResponse',
            'searchAddressBookByReference' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByReference',
            'searchAddressBookByReferenceResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByReferenceResponse',
            'getAddressBookLimit' => '\\Canpar\\Ship\\StructType\\GetAddressBookLimit',
            'getAddressBookLimitResponse' => '\\Canpar\\Ship\\StructType\\GetAddressBookLimitResponse',
            'exportCommodities' => '\\Canpar\\Ship\\StructType\\ExportCommodities',
            'exportCommoditiesResponse' => '\\Canpar\\Ship\\StructType\\ExportCommoditiesResponse',
            'searchAddressBookByPhone' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPhone',
            'searchAddressBookByPhoneResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPhoneResponse',
            'searchShipmentsByCostCentre' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByCostCentre',
            'searchShipmentsByCostCentreResponse' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByCostCentreResponse',
            'getLabelsAdvancedV2' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvancedV2',
            'getLabelsAdvancedV2Response' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvancedV2Response',
            'searchAddressBookByCity' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCity',
            'searchAddressBookByCityResponse' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCityResponse',
            'GetManifestRq' => '\\Canpar\\Ship\\StructType\\GetManifestRq',
            'GetManifestRs' => '\\Canpar\\Ship\\StructType\\GetManifestRs',
            'GetVersionRs' => '\\Canpar\\Ship\\StructType\\GetVersionRs',
            'GetLabelsRq' => '\\Canpar\\Ship\\StructType\\GetLabelsRq',
            'GetLabelsRs' => '\\Canpar\\Ship\\StructType\\GetLabelsRs',
            'GetUserRq' => '\\Canpar\\Ship\\StructType\\GetUserRq',
            'GetUserRs' => '\\Canpar\\Ship\\StructType\\GetUserRs',
            'GetProformaRq' => '\\Canpar\\Ship\\StructType\\GetProformaRq',
            'GetProformaRs' => '\\Canpar\\Ship\\StructType\\GetProformaRs',
            'UnvoidShipmentRq' => '\\Canpar\\Ship\\StructType\\UnvoidShipmentRq',
            'UnvoidShipmentRs' => '\\Canpar\\Ship\\StructType\\UnvoidShipmentRs',
            'EndOfDayRq' => '\\Canpar\\Ship\\StructType\\EndOfDayRq',
            'EndOfDayRs' => '\\Canpar\\Ship\\StructType\\EndOfDayRs',
            'GetPreferencesRq' => '\\Canpar\\Ship\\StructType\\GetPreferencesRq',
            'GetPreferencesRs' => '\\Canpar\\Ship\\StructType\\GetPreferencesRs',
            'SaveUserRq' => '\\Canpar\\Ship\\StructType\\SaveUserRq',
            'SaveUserRs' => '\\Canpar\\Ship\\StructType\\SaveUserRs',
            'DeleteBoxRq' => '\\Canpar\\Ship\\StructType\\DeleteBoxRq',
            'DeleteBoxRs' => '\\Canpar\\Ship\\StructType\\DeleteBoxRs',
            'DeleteUserRq' => '\\Canpar\\Ship\\StructType\\DeleteUserRq',
            'DeleteUserRs' => '\\Canpar\\Ship\\StructType\\DeleteUserRs',
            'HoldShipmentRq' => '\\Canpar\\Ship\\StructType\\HoldShipmentRq',
            'HoldShipmentRs' => '\\Canpar\\Ship\\StructType\\HoldShipmentRs',
            'DeleteCostCentreRq' => '\\Canpar\\Ship\\StructType\\DeleteCostCentreRq',
            'DeleteCostCentreRs' => '\\Canpar\\Ship\\StructType\\DeleteCostCentreRs',
            'GetSTOsRq' => '\\Canpar\\Ship\\StructType\\GetSTOsRq',
            'GetSTOsRs' => '\\Canpar\\Ship\\StructType\\GetSTOsRs',
            'SaveBoxRq' => '\\Canpar\\Ship\\StructType\\SaveBoxRq',
            'SaveBoxRs' => '\\Canpar\\Ship\\StructType\\SaveBoxRs',
            'ProcessShipmentRq' => '\\Canpar\\Ship\\StructType\\ProcessShipmentRq',
            'ProcessShipmentRs' => '\\Canpar\\Ship\\StructType\\ProcessShipmentRs',
            'GetCostCentresRq' => '\\Canpar\\Ship\\StructType\\GetCostCentresRq',
            'GetCostCentresRs' => '\\Canpar\\Ship\\StructType\\GetCostCentresRs',
            'GetCommoditiesRq' => '\\Canpar\\Ship\\StructType\\GetCommoditiesRq',
            'GetCommoditiesRs' => '\\Canpar\\Ship\\StructType\\GetCommoditiesRs',
            'DeleteSTORq' => '\\Canpar\\Ship\\StructType\\DeleteSTORq',
            'DeleteSTORs' => '\\Canpar\\Ship\\StructType\\DeleteSTORs',
            'SaveSTORq' => '\\Canpar\\Ship\\StructType\\SaveSTORq',
            'SaveSTORs' => '\\Canpar\\Ship\\StructType\\SaveSTORs',
            'VoidShipmentRq' => '\\Canpar\\Ship\\StructType\\VoidShipmentRq',
            'VoidShipmentRs' => '\\Canpar\\Ship\\StructType\\VoidShipmentRs',
            'SaveCommodityRq' => '\\Canpar\\Ship\\StructType\\SaveCommodityRq',
            'SaveCommodityRs' => '\\Canpar\\Ship\\StructType\\SaveCommodityRs',
            'GetBoxesRq' => '\\Canpar\\Ship\\StructType\\GetBoxesRq',
            'GetBoxesRs' => '\\Canpar\\Ship\\StructType\\GetBoxesRs',
            'SaveAddressBookRq' => '\\Canpar\\Ship\\StructType\\SaveAddressBookRq',
            'SaveAddressBookRs' => '\\Canpar\\Ship\\StructType\\SaveAddressBookRs',
            'SaveCostCentreRq' => '\\Canpar\\Ship\\StructType\\SaveCostCentreRq',
            'SaveCostCentreRs' => '\\Canpar\\Ship\\StructType\\SaveCostCentreRs',
            'SavePreferenceRq' => '\\Canpar\\Ship\\StructType\\SavePreferenceRq',
            'SavePreferenceRs' => '\\Canpar\\Ship\\StructType\\SavePreferenceRs',
            'DeleteCommodityRq' => '\\Canpar\\Ship\\StructType\\DeleteCommodityRq',
            'DeleteCommodityRs' => '\\Canpar\\Ship\\StructType\\DeleteCommodityRs',
            'DeletePreferenceRq' => '\\Canpar\\Ship\\StructType\\DeletePreferenceRq',
            'DeletePreferenceRs' => '\\Canpar\\Ship\\StructType\\DeletePreferenceRs',
            'SaveProformaRq' => '\\Canpar\\Ship\\StructType\\SaveProformaRq',
            'SaveProformaRs' => '\\Canpar\\Ship\\StructType\\SaveProformaRs',
            'AutoratingRq' => '\\Canpar\\Ship\\StructType\\AutoratingRq',
            'AutoratingRs' => '\\Canpar\\Ship\\StructType\\AutoratingRs',
            'ExportBoxesRq' => '\\Canpar\\Ship\\StructType\\ExportBoxesRq',
            'ExportBoxesRs' => '\\Canpar\\Ship\\StructType\\ExportBoxesRs',
            'DeleteProformaRq' => '\\Canpar\\Ship\\StructType\\DeleteProformaRq',
            'DeleteProformaRs' => '\\Canpar\\Ship\\StructType\\DeleteProformaRs',
            'GetFuelsRq' => '\\Canpar\\Ship\\StructType\\GetFuelsRq',
            'GetFuelsRs' => '\\Canpar\\Ship\\StructType\\GetFuelsRs',
            'SaveFuelRq' => '\\Canpar\\Ship\\StructType\\SaveFuelRq',
            'SaveFuelRs' => '\\Canpar\\Ship\\StructType\\SaveFuelRs',
            'ImportBoxesRq' => '\\Canpar\\Ship\\StructType\\ImportBoxesRq',
            'ImportBoxesRs' => '\\Canpar\\Ship\\StructType\\ImportBoxesRs',
            'ChangePasswordRq' => '\\Canpar\\Ship\\StructType\\ChangePasswordRq',
            'ChangePasswordRs' => '\\Canpar\\Ship\\StructType\\ChangePasswordRs',
            'GetUsersRq' => '\\Canpar\\Ship\\StructType\\GetUsersRq',
            'GetUsersRs' => '\\Canpar\\Ship\\StructType\\GetUsersRs',
            'SearchShipmentsByDeliveryAddressIdRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddressIdRq',
            'SearchShipmentsByDeliveryAddressIdRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddressIdRs',
            'SearchShipmentsByDeliveryPostalCodeRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryPostalCodeRq',
            'SearchShipmentsByDeliveryPostalCodeRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryPostalCodeRs',
            'SearchShipmentsByAlternativeReferenceRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByAlternativeReferenceRq',
            'SearchShipmentsByAlternativeReferenceRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByAlternativeReferenceRs',
            'SearchShipmentsByDeliveryProvinceRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryProvinceRq',
            'SearchShipmentsByDeliveryProvinceRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryProvinceRs',
            'SearchAddressBookByProvinceRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByProvinceRq',
            'SearchAddressBookByProvinceRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByProvinceRs',
            'GetShipmentsAfterDayRq' => '\\Canpar\\Ship\\StructType\\GetShipmentsAfterDayRq',
            'GetShipmentsAfterDayRs' => '\\Canpar\\Ship\\StructType\\GetShipmentsAfterDayRs',
            'SearchAddressBookByPostalCodeRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPostalCodeRq',
            'SearchAddressBookByPostalCodeRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPostalCodeRs',
            'SavePreferenceAllShippersRq' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllShippersRq',
            'SavePreferenceAllShippersRs' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllShippersRs',
            'SearchAddressBookByAddressIdRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByAddressIdRq',
            'SearchAddressBookByAddressIdRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByAddressIdRs',
            'ImportAddressBookRq' => '\\Canpar\\Ship\\StructType\\ImportAddressBookRq',
            'ImportAddressBookRs' => '\\Canpar\\Ship\\StructType\\ImportAddressBookRs',
            'GetLastManifestNumberRq' => '\\Canpar\\Ship\\StructType\\GetLastManifestNumberRq',
            'GetLastManifestNumberRs' => '\\Canpar\\Ship\\StructType\\GetLastManifestNumberRs',
            'SearchAddressByPhoneRq' => '\\Canpar\\Ship\\StructType\\SearchAddressByPhoneRq',
            'SearchAddressByPhoneRs' => '\\Canpar\\Ship\\StructType\\SearchAddressByPhoneRs',
            'ImportCommoditiesRq' => '\\Canpar\\Ship\\StructType\\ImportCommoditiesRq',
            'ImportCommoditiesRs' => '\\Canpar\\Ship\\StructType\\ImportCommoditiesRs',
            'SaveGlobalPreferenceRq' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreferenceRq',
            'SaveGlobalPreferenceRs' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreferenceRs',
            'SearchShipmentsByDeliveryNameRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryNameRq',
            'SearchShipmentsByDeliveryNameRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryNameRs',
            'GetGlobalPreferenceRq' => '\\Canpar\\Ship\\StructType\\GetGlobalPreferenceRq',
            'GetGlobalPreferenceRs' => '\\Canpar\\Ship\\StructType\\GetGlobalPreferenceRs',
            'DeleteGlobalPreferenceRq' => '\\Canpar\\Ship\\StructType\\DeleteGlobalPreferenceRq',
            'DeleteGlobalPreferenceRs' => '\\Canpar\\Ship\\StructType\\DeleteGlobalPreferenceRs',
            'SearchAddressBookByCostCentreRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCostCentreRq',
            'SearchAddressBookByCostCentreRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCostCentreRs',
            'SearchShipmentsByDeliveryCityRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryCityRq',
            'SearchShipmentsByDeliveryCityRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryCityRs',
            'SearchShipmentsByOrderIdRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByOrderIdRq',
            'SearchShipmentsByOrderIdRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByOrderIdRs',
            'SearchShipmentsByShippingDateRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByShippingDateRq',
            'SearchShipmentsByShippingDateRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByShippingDateRs',
            'ImportCostCentresRq' => '\\Canpar\\Ship\\StructType\\ImportCostCentresRq',
            'ImportCostCentresRs' => '\\Canpar\\Ship\\StructType\\ImportCostCentresRs',
            'SearchShipmentsByReferenceRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByReferenceRq',
            'SearchShipmentsByReferenceRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByReferenceRs',
            'ExportCostCentresRq' => '\\Canpar\\Ship\\StructType\\ExportCostCentresRq',
            'ExportCostCentresRs' => '\\Canpar\\Ship\\StructType\\ExportCostCentresRs',
            'SaveGlobalPreferenceAllUsersRq' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreferenceAllUsersRq',
            'SaveGlobalPreferenceAllUsersRs' => '\\Canpar\\Ship\\StructType\\SaveGlobalPreferenceAllUsersRs',
            'GetLabelsAdvancedRq' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvancedRq',
            'GetLabelsAdvancedRs' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvancedRs',
            'DeleteAddressBookRq' => '\\Canpar\\Ship\\StructType\\DeleteAddressBookRq',
            'DeleteAddressBookRs' => '\\Canpar\\Ship\\StructType\\DeleteAddressBookRs',
            'SearchShipmentsByBarcodeRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByBarcodeRq',
            'SearchShipmentsByBarcodeRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByBarcodeRs',
            'SearchShipmentsByManifestNumRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByManifestNumRq',
            'SearchShipmentsByManifestNumRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByManifestNumRs',
            'GetConsolidatedProformaRq' => '\\Canpar\\Ship\\StructType\\GetConsolidatedProformaRq',
            'GetConsolidatedProformaRs' => '\\Canpar\\Ship\\StructType\\GetConsolidatedProformaRs',
            'SearchShipmentsByDeliveryAddressRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddressRq',
            'SearchShipmentsByDeliveryAddressRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByDeliveryAddressRs',
            'GetShipmentsBeforeDayRq' => '\\Canpar\\Ship\\StructType\\GetShipmentsBeforeDayRq',
            'GetShipmentsBeforeDayRs' => '\\Canpar\\Ship\\StructType\\GetShipmentsBeforeDayRs',
            'SearchAddressBookByNameRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByNameRq',
            'SearchAddressBookByNameRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByNameRs',
            'ExportAddressBookRq' => '\\Canpar\\Ship\\StructType\\ExportAddressBookRq',
            'ExportAddressBookRs' => '\\Canpar\\Ship\\StructType\\ExportAddressBookRs',
            'SavePreferenceAllUsersRq' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllUsersRq',
            'SavePreferenceAllUsersRs' => '\\Canpar\\Ship\\StructType\\SavePreferenceAllUsersRs',
            'SearchAddressBookByReferenceRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByReferenceRq',
            'SearchAddressBookByReferenceRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByReferenceRs',
            'GetAddressBookLimitRq' => '\\Canpar\\Ship\\StructType\\GetAddressBookLimitRq',
            'GetAddressBookLimitRs' => '\\Canpar\\Ship\\StructType\\GetAddressBookLimitRs',
            'ExportCommoditiesRq' => '\\Canpar\\Ship\\StructType\\ExportCommoditiesRq',
            'ExportCommoditiesRs' => '\\Canpar\\Ship\\StructType\\ExportCommoditiesRs',
            'SearchAddressBookByPhoneRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPhoneRq',
            'SearchAddressBookByPhoneRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByPhoneRs',
            'SearchShipmentsByCostCentreRq' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByCostCentreRq',
            'SearchShipmentsByCostCentreRs' => '\\Canpar\\Ship\\StructType\\SearchShipmentsByCostCentreRs',
            'GetLabelsAdvancedV2Rq' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvancedV2Rq',
            'GetLabelsAdvancedV2Rs' => '\\Canpar\\Ship\\StructType\\GetLabelsAdvancedV2Rs',
            'SearchAddressBookByCityRq' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCityRq',
            'SearchAddressBookByCityRs' => '\\Canpar\\Ship\\StructType\\SearchAddressBookByCityRs',
            'CanshipUser' => '\\Canpar\\Ship\\StructType\\CanshipUser',
            'PaymentInfo' => '\\Canpar\\Ship\\StructType\\PaymentInfo',
            'Preference' => '\\Canpar\\Ship\\StructType\\Preference',
            'Address' => '\\Canpar\\Ship\\StructType\\Address',
            'Shipment' => '\\Canpar\\Ship\\StructType\\Shipment',
            'Package' => '\\Canpar\\Ship\\StructType\\Package',
            'COD' => '\\Canpar\\Ship\\StructType\\COD',
            'Proforma' => '\\Canpar\\Ship\\StructType\\Proforma',
            'ProformaItem' => '\\Canpar\\Ship\\StructType\\ProformaItem',
            'CommodityInfo' => '\\Canpar\\Ship\\StructType\\CommodityInfo',
            'STO' => '\\Canpar\\Ship\\StructType\\STO',
            'STOItem' => '\\Canpar\\Ship\\StructType\\STOItem',
            'Box' => '\\Canpar\\Ship\\StructType\\Box',
            'ProcessShipmentResult' => '\\Canpar\\Ship\\StructType\\ProcessShipmentResult',
            'CostCentre' => '\\Canpar\\Ship\\StructType\\CostCentre',
            'Commodity' => '\\Canpar\\Ship\\StructType\\Commodity',
            'AddressBook' => '\\Canpar\\Ship\\StructType\\AddressBook',
            'Fuel' => '\\Canpar\\Ship\\StructType\\Fuel',
            'GlobalPreference' => '\\Canpar\\Ship\\StructType\\GlobalPreference',
            'AddressBookLimit' => '\\Canpar\\Ship\\StructType\\AddressBookLimit',
            'FunctionParameter' => '\\Canpar\\Ship\\StructType\\FunctionParameter',
        );
    }
}
