<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www1.uc.se/UCSoapWeb/services/ucOrders2?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www1.uc.se/UCSoapWeb/services/ucOrders2?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Business ServiceType
 */
$business = new \ServiceType\Business($options);
/**
 * Sample call for businessReport operation/method
 */
if ($business->businessReport(new \StructType\BusinessReport()) !== false) {
    print_r($business->getResult());
} else {
    print_r($business->getLastError());
}
/**
 * Samples for Company ServiceType
 */
$company = new \ServiceType\Company($options);
/**
 * Sample call for companyReport operation/method
 */
if ($company->companyReport(new \StructType\CompanyReport()) !== false) {
    print_r($company->getResult());
} else {
    print_r($company->getLastError());
}
/**
 * Samples for Individual ServiceType
 */
$individual = new \ServiceType\Individual($options);
/**
 * Sample call for individualReport operation/method
 */
if ($individual->individualReport(new \StructType\IndividualReport()) !== false) {
    print_r($individual->getResult());
} else {
    print_r($individual->getLastError());
}
/**
 * Samples for Identity ServiceType
 */
$identity = new \ServiceType\Identity($options);
/**
 * Sample call for identityCheck operation/method
 */
if ($identity->identityCheck(new \StructType\IdentityCheck()) !== false) {
    print_r($identity->getResult());
} else {
    print_r($identity->getLastError());
}
/**
 * Sample call for identitySeekFys operation/method
 */
if ($identity->identitySeekFys(new \StructType\IdentitySeekFys()) !== false) {
    print_r($identity->getResult());
} else {
    print_r($identity->getLastError());
}
/**
 * Sample call for identitySeekJur operation/method
 */
if ($identity->identitySeekJur(new \StructType\IdentitySeekJur()) !== false) {
    print_r($identity->getResult());
} else {
    print_r($identity->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
/**
 * Sample call for retrieveLagomReport operation/method
 */
if ($retrieve->retrieveLagomReport(new \StructType\RetrieveLagomReport()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrieveAnnualReport operation/method
 */
if ($retrieve->retrieveAnnualReport(new \StructType\RetrieveAnnualReport()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for ping operation/method
 */
if ($ping->ping(new \StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
