<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xmlReply StructType
 * @subpackage Structs
 */
class XmlReply extends AbstractStructBase
{
    /**
     * The reports
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: ucOrderReply:reports
     * @var \StructType\Reports[]
     */
    public $reports;
    /**
     * The lagomlista
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: ucOrderReply:lagomlista
     * @var \StructType\Lagomlista
     */
    public $lagomlista;
    /**
     * Constructor method for xmlReply
     * @uses XmlReply::setReports()
     * @uses XmlReply::setLagomlista()
     * @param \StructType\Reports[] $reports
     * @param \StructType\Lagomlista $lagomlista
     */
    public function __construct(array $reports = array(), \StructType\Lagomlista $lagomlista = null)
    {
        $this
            ->setReports($reports)
            ->setLagomlista($lagomlista);
    }
    /**
     * Get reports value
     * @return \StructType\Reports[]
     */
    public function getReports()
    {
        return $this->reports;
    }
    /**
     * This method is responsible for validating the values passed to the setReports method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReports method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReportsForArrayConstraintsFromSetReports(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xmlReplyReportsItem) {
            // validation for constraint: itemType
            if (!$xmlReplyReportsItem instanceof \StructType\Reports) {
                $invalidValues[] = is_object($xmlReplyReportsItem) ? get_class($xmlReplyReportsItem) : sprintf('%s(%s)', gettype($xmlReplyReportsItem), var_export($xmlReplyReportsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The reports property can only contain items of type \StructType\Reports, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set reports value
     * @throws \InvalidArgumentException
     * @param \StructType\Reports[] $reports
     * @return \StructType\XmlReply
     */
    public function setReports(array $reports = array())
    {
        // validation for constraint: array
        if ('' !== ($reportsArrayErrorMessage = self::validateReportsForArrayConstraintsFromSetReports($reports))) {
            throw new \InvalidArgumentException($reportsArrayErrorMessage, __LINE__);
        }
        $this->reports = $reports;
        return $this;
    }
    /**
     * Add item to reports value
     * @throws \InvalidArgumentException
     * @param \StructType\Reports $item
     * @return \StructType\XmlReply
     */
    public function addToReports(\StructType\Reports $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Reports) {
            throw new \InvalidArgumentException(sprintf('The reports property can only contain items of type \StructType\Reports, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->reports[] = $item;
        return $this;
    }
    /**
     * Get lagomlista value
     * @return \StructType\Lagomlista|null
     */
    public function getLagomlista()
    {
        return $this->lagomlista;
    }
    /**
     * Set lagomlista value
     * @param \StructType\Lagomlista $lagomlista
     * @return \StructType\XmlReply
     */
    public function setLagomlista(\StructType\Lagomlista $lagomlista = null)
    {
        $this->lagomlista = $lagomlista;
        return $this;
    }
}
