<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ucReport StructType
 * @subpackage Structs
 */
class UcReport extends AbstractStructBase
{
    /**
     * The xmlReply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: ucOrderReply:xmlReply
     * @var \StructType\XmlReply
     */
    public $xmlReply;
    /**
     * The htmlReply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: ucOrderReply:htmlReply
     * @var string
     */
    public $htmlReply;
    /**
     * The reviewReply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: ucOrderReply:reviewReply
     * @var string
     */
    public $reviewReply;
    /**
     * The pdfReply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pdfReply;
    /**
     * Constructor method for ucReport
     * @uses UcReport::setXmlReply()
     * @uses UcReport::setHtmlReply()
     * @uses UcReport::setReviewReply()
     * @uses UcReport::setPdfReply()
     * @param \StructType\XmlReply $xmlReply
     * @param string $htmlReply
     * @param string $reviewReply
     * @param string $pdfReply
     */
    public function __construct(\StructType\XmlReply $xmlReply = null, $htmlReply = null, $reviewReply = null, $pdfReply = null)
    {
        $this
            ->setXmlReply($xmlReply)
            ->setHtmlReply($htmlReply)
            ->setReviewReply($reviewReply)
            ->setPdfReply($pdfReply);
    }
    /**
     * Get xmlReply value
     * @return \StructType\XmlReply|null
     */
    public function getXmlReply()
    {
        return $this->xmlReply;
    }
    /**
     * Set xmlReply value
     * @param \StructType\XmlReply $xmlReply
     * @return \StructType\UcReport
     */
    public function setXmlReply(\StructType\XmlReply $xmlReply = null)
    {
        $this->xmlReply = $xmlReply;
        return $this;
    }
    /**
     * Get htmlReply value
     * @return string|null
     */
    public function getHtmlReply()
    {
        return $this->htmlReply;
    }
    /**
     * Set htmlReply value
     * @param string $htmlReply
     * @return \StructType\UcReport
     */
    public function setHtmlReply($htmlReply = null)
    {
        // validation for constraint: string
        if (!is_null($htmlReply) && !is_string($htmlReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($htmlReply, true), gettype($htmlReply)), __LINE__);
        }
        $this->htmlReply = $htmlReply;
        return $this;
    }
    /**
     * Get reviewReply value
     * @return string|null
     */
    public function getReviewReply()
    {
        return $this->reviewReply;
    }
    /**
     * Set reviewReply value
     * @param string $reviewReply
     * @return \StructType\UcReport
     */
    public function setReviewReply($reviewReply = null)
    {
        // validation for constraint: string
        if (!is_null($reviewReply) && !is_string($reviewReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reviewReply, true), gettype($reviewReply)), __LINE__);
        }
        $this->reviewReply = $reviewReply;
        return $this;
    }
    /**
     * Get pdfReply value
     * @return string|null
     */
    public function getPdfReply()
    {
        return $this->pdfReply;
    }
    /**
     * Set pdfReply value
     * @param string $pdfReply
     * @return \StructType\UcReport
     */
    public function setPdfReply($pdfReply = null)
    {
        // validation for constraint: string
        if (!is_null($pdfReply) && !is_string($pdfReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdfReply, true), gettype($pdfReply)), __LINE__);
        }
        $this->pdfReply = $pdfReply;
        return $this;
    }
}
