<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ucReply StructType
 * @subpackage Structs
 */
class UcReply extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: ucOrderReply:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The ucReport
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ucOrderReply:ucReport
     * @var \StructType\UcReport[]
     */
    public $ucReport;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $version;
    /**
     * Constructor method for ucReply
     * @uses UcReply::setStatus()
     * @uses UcReply::setUcReport()
     * @uses UcReply::setVersion()
     * @param \StructType\Status $status
     * @param \StructType\UcReport[] $ucReport
     * @param string $version
     */
    public function __construct(\StructType\Status $status = null, array $ucReport = array(), $version = null)
    {
        $this
            ->setStatus($status)
            ->setUcReport($ucReport)
            ->setVersion($version);
    }
    /**
     * Get status value
     * @return \StructType\Status
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\UcReply
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get ucReport value
     * @return \StructType\UcReport[]|null
     */
    public function getUcReport()
    {
        return $this->ucReport;
    }
    /**
     * This method is responsible for validating the values passed to the setUcReport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUcReport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUcReportForArrayConstraintsFromSetUcReport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ucReplyUcReportItem) {
            // validation for constraint: itemType
            if (!$ucReplyUcReportItem instanceof \StructType\UcReport) {
                $invalidValues[] = is_object($ucReplyUcReportItem) ? get_class($ucReplyUcReportItem) : sprintf('%s(%s)', gettype($ucReplyUcReportItem), var_export($ucReplyUcReportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ucReport property can only contain items of type \StructType\UcReport, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ucReport value
     * @throws \InvalidArgumentException
     * @param \StructType\UcReport[] $ucReport
     * @return \StructType\UcReply
     */
    public function setUcReport(array $ucReport = array())
    {
        // validation for constraint: array
        if ('' !== ($ucReportArrayErrorMessage = self::validateUcReportForArrayConstraintsFromSetUcReport($ucReport))) {
            throw new \InvalidArgumentException($ucReportArrayErrorMessage, __LINE__);
        }
        $this->ucReport = $ucReport;
        return $this;
    }
    /**
     * Add item to ucReport value
     * @throws \InvalidArgumentException
     * @param \StructType\UcReport $item
     * @return \StructType\UcReply
     */
    public function addToUcReport(\StructType\UcReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UcReport) {
            throw new \InvalidArgumentException(sprintf('The ucReport property can only contain items of type \StructType\UcReport, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ucReport[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\UcReply
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
