<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for templateParams StructType
 * @subpackage Structs
 */
class TemplateParams extends AbstractStructBase
{
    /**
     * The templateparam
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\Templateparam[]
     */
    public $templateparam;
    /**
     * Constructor method for templateParams
     * @uses TemplateParams::setTemplateparam()
     * @param \StructType\Templateparam[] $templateparam
     */
    public function __construct(array $templateparam = array())
    {
        $this
            ->setTemplateparam($templateparam);
    }
    /**
     * Get templateparam value
     * @return \StructType\Templateparam[]|null
     */
    public function getTemplateparam()
    {
        return $this->templateparam;
    }
    /**
     * This method is responsible for validating the values passed to the setTemplateparam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemplateparam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemplateparamForArrayConstraintsFromSetTemplateparam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $templateParamsTemplateparamItem) {
            // validation for constraint: itemType
            if (!$templateParamsTemplateparamItem instanceof \StructType\Templateparam) {
                $invalidValues[] = is_object($templateParamsTemplateparamItem) ? get_class($templateParamsTemplateparamItem) : sprintf('%s(%s)', gettype($templateParamsTemplateparamItem), var_export($templateParamsTemplateparamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The templateparam property can only contain items of type \StructType\Templateparam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set templateparam value
     * @throws \InvalidArgumentException
     * @param \StructType\Templateparam[] $templateparam
     * @return \StructType\TemplateParams
     */
    public function setTemplateparam(array $templateparam = array())
    {
        // validation for constraint: array
        if ('' !== ($templateparamArrayErrorMessage = self::validateTemplateparamForArrayConstraintsFromSetTemplateparam($templateparam))) {
            throw new \InvalidArgumentException($templateparamArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($templateparam) && count($templateparam) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($templateparam)), __LINE__);
        }
        $this->templateparam = $templateparam;
        return $this;
    }
    /**
     * Add item to templateparam value
     * @throws \InvalidArgumentException
     * @param \StructType\Templateparam $item
     * @return \StructType\TemplateParams
     */
    public function addToTemplateparam(\StructType\Templateparam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Templateparam) {
            throw new \InvalidArgumentException(sprintf('The templateparam property can only contain items of type \StructType\Templateparam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->templateparam) && count($this->templateparam) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->templateparam)), __LINE__);
        }
        $this->templateparam[] = $item;
        return $this;
    }
}
