<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for templateIncome StructType
 * @subpackage Structs
 */
class TemplateIncome extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:amount
     * - totalDigits: 18
     * - use: required
     * @var int
     */
    public $value;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for templateIncome
     * @uses TemplateIncome::setValue()
     * @uses TemplateIncome::setType()
     * @param int $value
     * @param string $type
     */
    public function __construct($value = null, $type = null)
    {
        $this
            ->setValue($value)
            ->setType($type);
    }
    /**
     * Get value value
     * @return int
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param int $value
     * @return \StructType\TemplateIncome
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($value) && mb_strlen(preg_replace('/(\D)/', '', $value)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($value, true), mb_strlen(preg_replace('/(\D)/', '', $value))), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\AmountType::valueIsValid()
     * @uses \EnumType\AmountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\TemplateIncome
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmountType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AmountType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\AmountType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
