<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for template StructType
 * @subpackage Structs
 */
class Template extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The income
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TemplateIncome
     */
    public $income;
    /**
     * The coObject
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 10
     * - minOccurs: 0
     * - pattern: \d{6}-\d{4}|\d{10}
     * @var string
     */
    public $coObject;
    /**
     * The coObjectIncome
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:amount
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var int
     */
    public $coObjectIncome;
    /**
     * The templateParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TemplateParams
     */
    public $templateParams;
    /**
     * Constructor method for template
     * @uses Template::setId()
     * @uses Template::setIncome()
     * @uses Template::setCoObject()
     * @uses Template::setCoObjectIncome()
     * @uses Template::setTemplateParams()
     * @param string $id
     * @param \StructType\TemplateIncome $income
     * @param string $coObject
     * @param int $coObjectIncome
     * @param \StructType\TemplateParams $templateParams
     */
    public function __construct($id = null, \StructType\TemplateIncome $income = null, $coObject = null, $coObjectIncome = null, \StructType\TemplateParams $templateParams = null)
    {
        $this
            ->setId($id)
            ->setIncome($income)
            ->setCoObject($coObject)
            ->setCoObjectIncome($coObjectIncome)
            ->setTemplateParams($templateParams);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Template
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get income value
     * @return \StructType\TemplateIncome|null
     */
    public function getIncome()
    {
        return $this->income;
    }
    /**
     * Set income value
     * @param \StructType\TemplateIncome $income
     * @return \StructType\Template
     */
    public function setIncome(\StructType\TemplateIncome $income = null)
    {
        $this->income = $income;
        return $this;
    }
    /**
     * Get coObject value
     * @return string|null
     */
    public function getCoObject()
    {
        return $this->coObject;
    }
    /**
     * Set coObject value
     * @param string $coObject
     * @return \StructType\Template
     */
    public function setCoObject($coObject = null)
    {
        // validation for constraint: string
        if (!is_null($coObject) && !is_string($coObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coObject, true), gettype($coObject)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($coObject) && mb_strlen($coObject) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($coObject)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($coObject) && mb_strlen($coObject) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($coObject)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($coObject) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $coObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($coObject, true)), __LINE__);
        }
        $this->coObject = $coObject;
        return $this;
    }
    /**
     * Get coObjectIncome value
     * @return int|null
     */
    public function getCoObjectIncome()
    {
        return $this->coObjectIncome;
    }
    /**
     * Set coObjectIncome value
     * @param int $coObjectIncome
     * @return \StructType\Template
     */
    public function setCoObjectIncome($coObjectIncome = null)
    {
        // validation for constraint: int
        if (!is_null($coObjectIncome) && !(is_int($coObjectIncome) || ctype_digit($coObjectIncome))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coObjectIncome, true), gettype($coObjectIncome)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($coObjectIncome) && mb_strlen(preg_replace('/(\D)/', '', $coObjectIncome)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($coObjectIncome, true), mb_strlen(preg_replace('/(\D)/', '', $coObjectIncome))), __LINE__);
        }
        $this->coObjectIncome = $coObjectIncome;
        return $this;
    }
    /**
     * Get templateParams value
     * @return \StructType\TemplateParams|null
     */
    public function getTemplateParams()
    {
        return $this->templateParams;
    }
    /**
     * Set templateParams value
     * @param \StructType\TemplateParams $templateParams
     * @return \StructType\Template
     */
    public function setTemplateParams(\StructType\TemplateParams $templateParams = null)
    {
        $this->templateParams = $templateParams;
        return $this;
    }
}
