<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telephone StructType
 * @subpackage Structs
 */
class Telephone extends AbstractStructBase
{
    /**
     * The countrycode
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 3
     * @var int
     */
    public $countrycode;
    /**
     * The areacode
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $areacode;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 10
     * @var int
     */
    public $number;
    /**
     * Constructor method for telephone
     * @uses Telephone::setCountrycode()
     * @uses Telephone::setAreacode()
     * @uses Telephone::setNumber()
     * @param int $countrycode
     * @param int $areacode
     * @param int $number
     */
    public function __construct($countrycode = null, $areacode = null, $number = null)
    {
        $this
            ->setCountrycode($countrycode)
            ->setAreacode($areacode)
            ->setNumber($number);
    }
    /**
     * Get countrycode value
     * @return int|null
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param int $countrycode
     * @return \StructType\Telephone
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: int
        if (!is_null($countrycode) && !(is_int($countrycode) || ctype_digit($countrycode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countrycode, true), gettype($countrycode)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($countrycode) && mb_strlen(preg_replace('/(\D)/', '', $countrycode)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($countrycode, true), mb_strlen(preg_replace('/(\D)/', '', $countrycode))), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get areacode value
     * @return int|null
     */
    public function getAreacode()
    {
        return $this->areacode;
    }
    /**
     * Set areacode value
     * @param int $areacode
     * @return \StructType\Telephone
     */
    public function setAreacode($areacode = null)
    {
        // validation for constraint: int
        if (!is_null($areacode) && !(is_int($areacode) || ctype_digit($areacode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areacode, true), gettype($areacode)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($areacode) && mb_strlen(preg_replace('/(\D)/', '', $areacode)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($areacode, true), mb_strlen(preg_replace('/(\D)/', '', $areacode))), __LINE__);
        }
        $this->areacode = $areacode;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\Telephone
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($number) && mb_strlen(preg_replace('/(\D)/', '', $number)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($number, true), mb_strlen(preg_replace('/(\D)/', '', $number))), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
