<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for status StructType
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: ucOrderReply:message
     * @var \StructType\Message
     */
    public $message;
    /**
     * The result
     * @var string
     */
    public $result;
    /**
     * Constructor method for status
     * @uses Status::setMessage()
     * @uses Status::setResult()
     * @param \StructType\Message $message
     * @param string $result
     */
    public function __construct(\StructType\Message $message = null, $result = null)
    {
        $this
            ->setMessage($message)
            ->setResult($result);
    }
    /**
     * Get message value
     * @return \StructType\Message|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param \StructType\Message $message
     * @return \StructType\Status
     */
    public function setMessage(\StructType\Message $message = null)
    {
        $this->message = $message;
        return $this;
    }
    /**
     * Get result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param string $result
     * @return \StructType\Status
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
}
