<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for seekJuridiker StructType
 * @subpackage Structs
 */
class SeekJuridiker extends AbstractStructBase
{
    /**
     * The seekCategoryJur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $seekCategoryJur;
    /**
     * The xmlReply
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $xmlReply;
    /**
     * The htmlReply
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $htmlReply;
    /**
     * The seekName
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:nameBase
     * - maxLength: 48
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $seekName;
    /**
     * The adress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Adress
     */
    public $adress;
    /**
     * The telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $telephone;
    /**
     * The reviewReply
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $reviewReply;
    /**
     * Constructor method for seekJuridiker
     * @uses SeekJuridiker::setSeekCategoryJur()
     * @uses SeekJuridiker::setXmlReply()
     * @uses SeekJuridiker::setHtmlReply()
     * @uses SeekJuridiker::setSeekName()
     * @uses SeekJuridiker::setAdress()
     * @uses SeekJuridiker::setTelephone()
     * @uses SeekJuridiker::setReviewReply()
     * @param string $seekCategoryJur
     * @param bool $xmlReply
     * @param bool $htmlReply
     * @param string $seekName
     * @param \StructType\Adress $adress
     * @param \StructType\Telephone $telephone
     * @param bool $reviewReply
     */
    public function __construct($seekCategoryJur = null, $xmlReply = null, $htmlReply = null, $seekName = null, \StructType\Adress $adress = null, \StructType\Telephone $telephone = null, $reviewReply = null)
    {
        $this
            ->setSeekCategoryJur($seekCategoryJur)
            ->setXmlReply($xmlReply)
            ->setHtmlReply($htmlReply)
            ->setSeekName($seekName)
            ->setAdress($adress)
            ->setTelephone($telephone)
            ->setReviewReply($reviewReply);
    }
    /**
     * Get seekCategoryJur value
     * @return string
     */
    public function getSeekCategoryJur()
    {
        return $this->seekCategoryJur;
    }
    /**
     * Set seekCategoryJur value
     * @uses \EnumType\SeekCategoryJur::valueIsValid()
     * @uses \EnumType\SeekCategoryJur::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seekCategoryJur
     * @return \StructType\SeekJuridiker
     */
    public function setSeekCategoryJur($seekCategoryJur = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeekCategoryJur::valueIsValid($seekCategoryJur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SeekCategoryJur', is_array($seekCategoryJur) ? implode(', ', $seekCategoryJur) : var_export($seekCategoryJur, true), implode(', ', \EnumType\SeekCategoryJur::getValidValues())), __LINE__);
        }
        $this->seekCategoryJur = $seekCategoryJur;
        return $this;
    }
    /**
     * Get xmlReply value
     * @return bool
     */
    public function getXmlReply()
    {
        return $this->xmlReply;
    }
    /**
     * Set xmlReply value
     * @param bool $xmlReply
     * @return \StructType\SeekJuridiker
     */
    public function setXmlReply($xmlReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($xmlReply) && !is_bool($xmlReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($xmlReply, true), gettype($xmlReply)), __LINE__);
        }
        $this->xmlReply = $xmlReply;
        return $this;
    }
    /**
     * Get htmlReply value
     * @return bool
     */
    public function getHtmlReply()
    {
        return $this->htmlReply;
    }
    /**
     * Set htmlReply value
     * @param bool $htmlReply
     * @return \StructType\SeekJuridiker
     */
    public function setHtmlReply($htmlReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($htmlReply) && !is_bool($htmlReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($htmlReply, true), gettype($htmlReply)), __LINE__);
        }
        $this->htmlReply = $htmlReply;
        return $this;
    }
    /**
     * Get seekName value
     * @return string|null
     */
    public function getSeekName()
    {
        return $this->seekName;
    }
    /**
     * Set seekName value
     * @param string $seekName
     * @return \StructType\SeekJuridiker
     */
    public function setSeekName($seekName = null)
    {
        // validation for constraint: string
        if (!is_null($seekName) && !is_string($seekName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seekName, true), gettype($seekName)), __LINE__);
        }
        // validation for constraint: maxLength(48)
        if (!is_null($seekName) && mb_strlen($seekName) > 48) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 48', mb_strlen($seekName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($seekName) && mb_strlen($seekName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($seekName)), __LINE__);
        }
        $this->seekName = $seekName;
        return $this;
    }
    /**
     * Get adress value
     * @return \StructType\Adress|null
     */
    public function getAdress()
    {
        return $this->adress;
    }
    /**
     * Set adress value
     * @param \StructType\Adress $adress
     * @return \StructType\SeekJuridiker
     */
    public function setAdress(\StructType\Adress $adress = null)
    {
        $this->adress = $adress;
        return $this;
    }
    /**
     * Get telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
    /**
     * Set telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\SeekJuridiker
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->telephone = $telephone;
        return $this;
    }
    /**
     * Get reviewReply value
     * @return bool|null
     */
    public function getReviewReply()
    {
        return $this->reviewReply;
    }
    /**
     * Set reviewReply value
     * @param bool $reviewReply
     * @return \StructType\SeekJuridiker
     */
    public function setReviewReply($reviewReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($reviewReply) && !is_bool($reviewReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reviewReply, true), gettype($reviewReply)), __LINE__);
        }
        $this->reviewReply = $reviewReply;
        return $this;
    }
}
