<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for seekFysiker StructType
 * @subpackage Structs
 */
class SeekFysiker extends AbstractStructBase
{
    /**
     * The seekCategoryFys
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $seekCategoryFys;
    /**
     * The xmlReply
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $xmlReply;
    /**
     * The htmlReply
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $htmlReply;
    /**
     * The seekName
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:nameBase
     * - maxLength: 48
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $seekName;
    /**
     * The adress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Adress
     */
    public $adress;
    /**
     * The reviewReply
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $reviewReply;
    /**
     * Constructor method for seekFysiker
     * @uses SeekFysiker::setSeekCategoryFys()
     * @uses SeekFysiker::setXmlReply()
     * @uses SeekFysiker::setHtmlReply()
     * @uses SeekFysiker::setSeekName()
     * @uses SeekFysiker::setAdress()
     * @uses SeekFysiker::setReviewReply()
     * @param string $seekCategoryFys
     * @param bool $xmlReply
     * @param bool $htmlReply
     * @param string $seekName
     * @param \StructType\Adress $adress
     * @param bool $reviewReply
     */
    public function __construct($seekCategoryFys = null, $xmlReply = null, $htmlReply = null, $seekName = null, \StructType\Adress $adress = null, $reviewReply = null)
    {
        $this
            ->setSeekCategoryFys($seekCategoryFys)
            ->setXmlReply($xmlReply)
            ->setHtmlReply($htmlReply)
            ->setSeekName($seekName)
            ->setAdress($adress)
            ->setReviewReply($reviewReply);
    }
    /**
     * Get seekCategoryFys value
     * @return string
     */
    public function getSeekCategoryFys()
    {
        return $this->seekCategoryFys;
    }
    /**
     * Set seekCategoryFys value
     * @uses \EnumType\SeekCategoryFys::valueIsValid()
     * @uses \EnumType\SeekCategoryFys::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seekCategoryFys
     * @return \StructType\SeekFysiker
     */
    public function setSeekCategoryFys($seekCategoryFys = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeekCategoryFys::valueIsValid($seekCategoryFys)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SeekCategoryFys', is_array($seekCategoryFys) ? implode(', ', $seekCategoryFys) : var_export($seekCategoryFys, true), implode(', ', \EnumType\SeekCategoryFys::getValidValues())), __LINE__);
        }
        $this->seekCategoryFys = $seekCategoryFys;
        return $this;
    }
    /**
     * Get xmlReply value
     * @return bool
     */
    public function getXmlReply()
    {
        return $this->xmlReply;
    }
    /**
     * Set xmlReply value
     * @param bool $xmlReply
     * @return \StructType\SeekFysiker
     */
    public function setXmlReply($xmlReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($xmlReply) && !is_bool($xmlReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($xmlReply, true), gettype($xmlReply)), __LINE__);
        }
        $this->xmlReply = $xmlReply;
        return $this;
    }
    /**
     * Get htmlReply value
     * @return bool
     */
    public function getHtmlReply()
    {
        return $this->htmlReply;
    }
    /**
     * Set htmlReply value
     * @param bool $htmlReply
     * @return \StructType\SeekFysiker
     */
    public function setHtmlReply($htmlReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($htmlReply) && !is_bool($htmlReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($htmlReply, true), gettype($htmlReply)), __LINE__);
        }
        $this->htmlReply = $htmlReply;
        return $this;
    }
    /**
     * Get seekName value
     * @return string|null
     */
    public function getSeekName()
    {
        return $this->seekName;
    }
    /**
     * Set seekName value
     * @param string $seekName
     * @return \StructType\SeekFysiker
     */
    public function setSeekName($seekName = null)
    {
        // validation for constraint: string
        if (!is_null($seekName) && !is_string($seekName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seekName, true), gettype($seekName)), __LINE__);
        }
        // validation for constraint: maxLength(48)
        if (!is_null($seekName) && mb_strlen($seekName) > 48) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 48', mb_strlen($seekName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($seekName) && mb_strlen($seekName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($seekName)), __LINE__);
        }
        $this->seekName = $seekName;
        return $this;
    }
    /**
     * Get adress value
     * @return \StructType\Adress|null
     */
    public function getAdress()
    {
        return $this->adress;
    }
    /**
     * Set adress value
     * @param \StructType\Adress $adress
     * @return \StructType\SeekFysiker
     */
    public function setAdress(\StructType\Adress $adress = null)
    {
        $this->adress = $adress;
        return $this;
    }
    /**
     * Get reviewReply value
     * @return bool|null
     */
    public function getReviewReply()
    {
        return $this->reviewReply;
    }
    /**
     * Set reviewReply value
     * @param bool $reviewReply
     * @return \StructType\SeekFysiker
     */
    public function setReviewReply($reviewReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($reviewReply) && !is_bool($reviewReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reviewReply, true), gettype($reviewReply)), __LINE__);
        }
        $this->reviewReply = $reviewReply;
        return $this;
    }
}
