<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for retrieveLagomReport StructType
 * @subpackage Structs
 */
class RetrieveLagomReport extends AbstractStructBase
{
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The datastoreid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 3
     * - use: required
     * @var string
     */
    public $datastoreid;
    /**
     * The objectid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - minLength: 10
     * - pattern: \d{6}-\d{4}|\d{10}
     * - use: required
     * @var string
     */
    public $objectid;
    /**
     * The sequenceNr
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $sequenceNr;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * Constructor method for retrieveLagomReport
     * @uses RetrieveLagomReport::setCustomer()
     * @uses RetrieveLagomReport::setDatastoreid()
     * @uses RetrieveLagomReport::setObjectid()
     * @uses RetrieveLagomReport::setSequenceNr()
     * @uses RetrieveLagomReport::setVersion()
     * @param \StructType\Customer $customer
     * @param string $datastoreid
     * @param string $objectid
     * @param int $sequenceNr
     * @param string $version
     */
    public function __construct(\StructType\Customer $customer = null, $datastoreid = null, $objectid = null, $sequenceNr = null, $version = null)
    {
        $this
            ->setCustomer($customer)
            ->setDatastoreid($datastoreid)
            ->setObjectid($objectid)
            ->setSequenceNr($sequenceNr)
            ->setVersion($version);
    }
    /**
     * Get customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\RetrieveLagomReport
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get datastoreid value
     * @return string
     */
    public function getDatastoreid()
    {
        return $this->datastoreid;
    }
    /**
     * Set datastoreid value
     * @param string $datastoreid
     * @return \StructType\RetrieveLagomReport
     */
    public function setDatastoreid($datastoreid = null)
    {
        // validation for constraint: string
        if (!is_null($datastoreid) && !is_string($datastoreid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datastoreid, true), gettype($datastoreid)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($datastoreid) && mb_strlen($datastoreid) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($datastoreid)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($datastoreid) && mb_strlen($datastoreid) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($datastoreid)), __LINE__);
        }
        $this->datastoreid = $datastoreid;
        return $this;
    }
    /**
     * Get objectid value
     * @return string
     */
    public function getObjectid()
    {
        return $this->objectid;
    }
    /**
     * Set objectid value
     * @param string $objectid
     * @return \StructType\RetrieveLagomReport
     */
    public function setObjectid($objectid = null)
    {
        // validation for constraint: string
        if (!is_null($objectid) && !is_string($objectid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectid, true), gettype($objectid)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($objectid) && mb_strlen($objectid) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($objectid)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($objectid) && mb_strlen($objectid) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($objectid)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($objectid) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $objectid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($objectid, true)), __LINE__);
        }
        $this->objectid = $objectid;
        return $this;
    }
    /**
     * Get sequenceNr value
     * @return int
     */
    public function getSequenceNr()
    {
        return $this->sequenceNr;
    }
    /**
     * Set sequenceNr value
     * @param int $sequenceNr
     * @return \StructType\RetrieveLagomReport
     */
    public function setSequenceNr($sequenceNr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNr) && !(is_int($sequenceNr) || ctype_digit($sequenceNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNr, true), gettype($sequenceNr)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($sequenceNr) && $sequenceNr > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($sequenceNr, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($sequenceNr) && $sequenceNr < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($sequenceNr, true)), __LINE__);
        }
        $this->sequenceNr = $sequenceNr;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\RetrieveLagomReport
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
