<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for retrieveAnnualReport StructType
 * @subpackage Structs
 */
class RetrieveAnnualReport extends AbstractStructBase
{
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The retrieveAction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $retrieveAction;
    /**
     * The annualQuery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AnnualQuery
     */
    public $annualQuery;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * Constructor method for retrieveAnnualReport
     * @uses RetrieveAnnualReport::setCustomer()
     * @uses RetrieveAnnualReport::setRetrieveAction()
     * @uses RetrieveAnnualReport::setAnnualQuery()
     * @uses RetrieveAnnualReport::setVersion()
     * @param \StructType\Customer $customer
     * @param string $retrieveAction
     * @param \StructType\AnnualQuery $annualQuery
     * @param string $version
     */
    public function __construct(\StructType\Customer $customer = null, $retrieveAction = null, \StructType\AnnualQuery $annualQuery = null, $version = null)
    {
        $this
            ->setCustomer($customer)
            ->setRetrieveAction($retrieveAction)
            ->setAnnualQuery($annualQuery)
            ->setVersion($version);
    }
    /**
     * Get customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\RetrieveAnnualReport
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get retrieveAction value
     * @return string
     */
    public function getRetrieveAction()
    {
        return $this->retrieveAction;
    }
    /**
     * Set retrieveAction value
     * @uses \EnumType\RetrieveAction::valueIsValid()
     * @uses \EnumType\RetrieveAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retrieveAction
     * @return \StructType\RetrieveAnnualReport
     */
    public function setRetrieveAction($retrieveAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveAction::valueIsValid($retrieveAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveAction', is_array($retrieveAction) ? implode(', ', $retrieveAction) : var_export($retrieveAction, true), implode(', ', \EnumType\RetrieveAction::getValidValues())), __LINE__);
        }
        $this->retrieveAction = $retrieveAction;
        return $this;
    }
    /**
     * Get annualQuery value
     * @return \StructType\AnnualQuery
     */
    public function getAnnualQuery()
    {
        return $this->annualQuery;
    }
    /**
     * Set annualQuery value
     * @param \StructType\AnnualQuery $annualQuery
     * @return \StructType\RetrieveAnnualReport
     */
    public function setAnnualQuery(\StructType\AnnualQuery $annualQuery = null)
    {
        $this->annualQuery = $annualQuery;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\RetrieveAnnualReport
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
