<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reports StructType
 * @subpackage Structs
 */
class Reports extends AbstractStructBase
{
    /**
     * The report
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: ucOrderReply:report
     * @var \StructType\Report[]
     */
    public $report;
    /**
     * The lang
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $lang;
    /**
     * Constructor method for reports
     * @uses Reports::setReport()
     * @uses Reports::setLang()
     * @param \StructType\Report[] $report
     * @param string $lang
     */
    public function __construct(array $report = array(), $lang = null)
    {
        $this
            ->setReport($report)
            ->setLang($lang);
    }
    /**
     * Get report value
     * @return \StructType\Report[]
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * This method is responsible for validating the values passed to the setReport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReportForArrayConstraintsFromSetReport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reportsReportItem) {
            // validation for constraint: itemType
            if (!$reportsReportItem instanceof \StructType\Report) {
                $invalidValues[] = is_object($reportsReportItem) ? get_class($reportsReportItem) : sprintf('%s(%s)', gettype($reportsReportItem), var_export($reportsReportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The report property can only contain items of type \StructType\Report, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report[] $report
     * @return \StructType\Reports
     */
    public function setReport(array $report = array())
    {
        // validation for constraint: array
        if ('' !== ($reportArrayErrorMessage = self::validateReportForArrayConstraintsFromSetReport($report))) {
            throw new \InvalidArgumentException($reportArrayErrorMessage, __LINE__);
        }
        $this->report = $report;
        return $this;
    }
    /**
     * Add item to report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report $item
     * @return \StructType\Reports
     */
    public function addToReport(\StructType\Report $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Report) {
            throw new \InvalidArgumentException(sprintf('The report property can only contain items of type \StructType\Report, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->report[] = $item;
        return $this;
    }
    /**
     * Get lang value
     * @return string
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\Reports
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
}
