<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportQuery StructType
 * @subpackage Structs
 */
class ReportQuery extends AbstractStructBase
{
    /**
     * The object
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 10
     * - minOccurs: 1
     * - pattern: \d{6}-\d{4}|\d{10}
     * @var string
     */
    public $object;
    /**
     * The xmlReply
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $xmlReply;
    /**
     * The htmlReply
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $htmlReply;
    /**
     * The orderedBy
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:nameBase
     * - maxLength: 48
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderedBy;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:nameBase
     * - maxLength: 32
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The override
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $override;
    /**
     * The creditSeeked
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:amount
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 8
     * @var int
     */
    public $creditSeeked;
    /**
     * The template
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Template
     */
    public $template;
    /**
     * The broker
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:nameBase
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 4
     * - minOccurs: 0
     * @var string
     */
    public $broker;
    /**
     * The purpose
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:amount
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 2
     * @var int
     */
    public $purpose;
    /**
     * The emailAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 254
     * - maxOccurs: 1
     * - minLength: 7
     * - minOccurs: 0
     * @var string
     */
    public $emailAddress;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - maxOccurs: 1
     * - minLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The reviewReply
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $reviewReply;
    /**
     * The pdfReply
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $pdfReply;
    /**
     * The extendedDetails
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $extendedDetails;
    /**
     * The lang
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $lang;
    /**
     * Constructor method for reportQuery
     * @uses ReportQuery::setObject()
     * @uses ReportQuery::setXmlReply()
     * @uses ReportQuery::setHtmlReply()
     * @uses ReportQuery::setOrderedBy()
     * @uses ReportQuery::setReference()
     * @uses ReportQuery::setOverride()
     * @uses ReportQuery::setCreditSeeked()
     * @uses ReportQuery::setTemplate()
     * @uses ReportQuery::setBroker()
     * @uses ReportQuery::setPurpose()
     * @uses ReportQuery::setEmailAddress()
     * @uses ReportQuery::setPhoneNumber()
     * @uses ReportQuery::setReviewReply()
     * @uses ReportQuery::setPdfReply()
     * @uses ReportQuery::setExtendedDetails()
     * @uses ReportQuery::setLang()
     * @param string $object
     * @param bool $xmlReply
     * @param bool $htmlReply
     * @param string $orderedBy
     * @param string $reference
     * @param string $override
     * @param int $creditSeeked
     * @param \StructType\Template $template
     * @param string $broker
     * @param int $purpose
     * @param string $emailAddress
     * @param string $phoneNumber
     * @param bool $reviewReply
     * @param bool $pdfReply
     * @param bool $extendedDetails
     * @param string $lang
     */
    public function __construct($object = null, $xmlReply = null, $htmlReply = null, $orderedBy = null, $reference = null, $override = null, $creditSeeked = null, \StructType\Template $template = null, $broker = null, $purpose = null, $emailAddress = null, $phoneNumber = null, $reviewReply = null, $pdfReply = null, $extendedDetails = null, $lang = null)
    {
        $this
            ->setObject($object)
            ->setXmlReply($xmlReply)
            ->setHtmlReply($htmlReply)
            ->setOrderedBy($orderedBy)
            ->setReference($reference)
            ->setOverride($override)
            ->setCreditSeeked($creditSeeked)
            ->setTemplate($template)
            ->setBroker($broker)
            ->setPurpose($purpose)
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber)
            ->setReviewReply($reviewReply)
            ->setPdfReply($pdfReply)
            ->setExtendedDetails($extendedDetails)
            ->setLang($lang);
    }
    /**
     * Get object value
     * @return string
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return \StructType\ReportQuery
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($object, true), gettype($object)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($object) && mb_strlen($object) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($object)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($object) && mb_strlen($object) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($object)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($object) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($object, true)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get xmlReply value
     * @return bool
     */
    public function getXmlReply()
    {
        return $this->xmlReply;
    }
    /**
     * Set xmlReply value
     * @param bool $xmlReply
     * @return \StructType\ReportQuery
     */
    public function setXmlReply($xmlReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($xmlReply) && !is_bool($xmlReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($xmlReply, true), gettype($xmlReply)), __LINE__);
        }
        $this->xmlReply = $xmlReply;
        return $this;
    }
    /**
     * Get htmlReply value
     * @return bool
     */
    public function getHtmlReply()
    {
        return $this->htmlReply;
    }
    /**
     * Set htmlReply value
     * @param bool $htmlReply
     * @return \StructType\ReportQuery
     */
    public function setHtmlReply($htmlReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($htmlReply) && !is_bool($htmlReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($htmlReply, true), gettype($htmlReply)), __LINE__);
        }
        $this->htmlReply = $htmlReply;
        return $this;
    }
    /**
     * Get orderedBy value
     * @return string|null
     */
    public function getOrderedBy()
    {
        return $this->orderedBy;
    }
    /**
     * Set orderedBy value
     * @param string $orderedBy
     * @return \StructType\ReportQuery
     */
    public function setOrderedBy($orderedBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderedBy) && !is_string($orderedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderedBy, true), gettype($orderedBy)), __LINE__);
        }
        // validation for constraint: maxLength(48)
        if (!is_null($orderedBy) && mb_strlen($orderedBy) > 48) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 48', mb_strlen($orderedBy)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderedBy) && mb_strlen($orderedBy) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderedBy)), __LINE__);
        }
        $this->orderedBy = $orderedBy;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ReportQuery
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($reference) && mb_strlen($reference) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($reference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reference) && mb_strlen($reference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get override value
     * @return string|null
     */
    public function getOverride()
    {
        return $this->override;
    }
    /**
     * Set override value
     * @uses \EnumType\Override::valueIsValid()
     * @uses \EnumType\Override::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $override
     * @return \StructType\ReportQuery
     */
    public function setOverride($override = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Override::valueIsValid($override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Override', is_array($override) ? implode(', ', $override) : var_export($override, true), implode(', ', \EnumType\Override::getValidValues())), __LINE__);
        }
        $this->override = $override;
        return $this;
    }
    /**
     * Get creditSeeked value
     * @return int|null
     */
    public function getCreditSeeked()
    {
        return $this->creditSeeked;
    }
    /**
     * Set creditSeeked value
     * @param int $creditSeeked
     * @return \StructType\ReportQuery
     */
    public function setCreditSeeked($creditSeeked = null)
    {
        // validation for constraint: int
        if (!is_null($creditSeeked) && !(is_int($creditSeeked) || ctype_digit($creditSeeked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditSeeked, true), gettype($creditSeeked)), __LINE__);
        }
        // validation for constraint: totalDigits(8)
        if (!is_null($creditSeeked) && mb_strlen(preg_replace('/(\D)/', '', $creditSeeked)) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 8 digits, "%d" given', var_export($creditSeeked, true), mb_strlen(preg_replace('/(\D)/', '', $creditSeeked))), __LINE__);
        }
        $this->creditSeeked = $creditSeeked;
        return $this;
    }
    /**
     * Get template value
     * @return \StructType\Template|null
     */
    public function getTemplate()
    {
        return $this->template;
    }
    /**
     * Set template value
     * @param \StructType\Template $template
     * @return \StructType\ReportQuery
     */
    public function setTemplate(\StructType\Template $template = null)
    {
        $this->template = $template;
        return $this;
    }
    /**
     * Get broker value
     * @return string|null
     */
    public function getBroker()
    {
        return $this->broker;
    }
    /**
     * Set broker value
     * @param string $broker
     * @return \StructType\ReportQuery
     */
    public function setBroker($broker = null)
    {
        // validation for constraint: string
        if (!is_null($broker) && !is_string($broker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($broker, true), gettype($broker)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($broker) && mb_strlen($broker) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($broker)), __LINE__);
        }
        // validation for constraint: minLength(4)
        if (!is_null($broker) && mb_strlen($broker) < 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 4', mb_strlen($broker)), __LINE__);
        }
        $this->broker = $broker;
        return $this;
    }
    /**
     * Get purpose value
     * @return int|null
     */
    public function getPurpose()
    {
        return $this->purpose;
    }
    /**
     * Set purpose value
     * @param int $purpose
     * @return \StructType\ReportQuery
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: int
        if (!is_null($purpose) && !(is_int($purpose) || ctype_digit($purpose))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($purpose) && mb_strlen(preg_replace('/(\D)/', '', $purpose)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($purpose, true), mb_strlen(preg_replace('/(\D)/', '', $purpose))), __LINE__);
        }
        $this->purpose = $purpose;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\ReportQuery
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        // validation for constraint: maxLength(254)
        if (!is_null($emailAddress) && mb_strlen($emailAddress) > 254) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 254', mb_strlen($emailAddress)), __LINE__);
        }
        // validation for constraint: minLength(7)
        if (!is_null($emailAddress) && mb_strlen($emailAddress) < 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 7', mb_strlen($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \StructType\ReportQuery
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($phoneNumber)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get reviewReply value
     * @return bool|null
     */
    public function getReviewReply()
    {
        return $this->reviewReply;
    }
    /**
     * Set reviewReply value
     * @param bool $reviewReply
     * @return \StructType\ReportQuery
     */
    public function setReviewReply($reviewReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($reviewReply) && !is_bool($reviewReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reviewReply, true), gettype($reviewReply)), __LINE__);
        }
        $this->reviewReply = $reviewReply;
        return $this;
    }
    /**
     * Get pdfReply value
     * @return bool|null
     */
    public function getPdfReply()
    {
        return $this->pdfReply;
    }
    /**
     * Set pdfReply value
     * @param bool $pdfReply
     * @return \StructType\ReportQuery
     */
    public function setPdfReply($pdfReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($pdfReply) && !is_bool($pdfReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pdfReply, true), gettype($pdfReply)), __LINE__);
        }
        $this->pdfReply = $pdfReply;
        return $this;
    }
    /**
     * Get extendedDetails value
     * @return bool|null
     */
    public function getExtendedDetails()
    {
        return $this->extendedDetails;
    }
    /**
     * Set extendedDetails value
     * @param bool $extendedDetails
     * @return \StructType\ReportQuery
     */
    public function setExtendedDetails($extendedDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedDetails) && !is_bool($extendedDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extendedDetails, true), gettype($extendedDetails)), __LINE__);
        }
        $this->extendedDetails = $extendedDetails;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lang
     * @return \StructType\ReportQuery
     */
    public function setLang($lang = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($lang) ? implode(', ', $lang) : var_export($lang, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
}
