<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for report StructType
 * @subpackage Structs
 */
class Report extends AbstractStructBase
{
    /**
     * The group
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: ucOrderReply:group
     * @var \StructType\Group[]
     */
    public $group;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The styp
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $styp;
    /**
     * The index
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $index;
    /**
     * The lagomid
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $lagomid;
    /**
     * The lagomlopnr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $lagomlopnr;
    /**
     * Constructor method for report
     * @uses Report::setGroup()
     * @uses Report::setId()
     * @uses Report::setName()
     * @uses Report::setStyp()
     * @uses Report::setIndex()
     * @uses Report::setLagomid()
     * @uses Report::setLagomlopnr()
     * @param \StructType\Group[] $group
     * @param string $id
     * @param string $name
     * @param string $styp
     * @param string $index
     * @param string $lagomid
     * @param string $lagomlopnr
     */
    public function __construct(array $group = array(), $id = null, $name = null, $styp = null, $index = null, $lagomid = null, $lagomlopnr = null)
    {
        $this
            ->setGroup($group)
            ->setId($id)
            ->setName($name)
            ->setStyp($styp)
            ->setIndex($index)
            ->setLagomid($lagomid)
            ->setLagomlopnr($lagomlopnr);
    }
    /**
     * Get group value
     * @return \StructType\Group[]
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * This method is responsible for validating the values passed to the setGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupForArrayConstraintsFromSetGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reportGroupItem) {
            // validation for constraint: itemType
            if (!$reportGroupItem instanceof \StructType\Group) {
                $invalidValues[] = is_object($reportGroupItem) ? get_class($reportGroupItem) : sprintf('%s(%s)', gettype($reportGroupItem), var_export($reportGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The group property can only contain items of type \StructType\Group, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set group value
     * @throws \InvalidArgumentException
     * @param \StructType\Group[] $group
     * @return \StructType\Report
     */
    public function setGroup(array $group = array())
    {
        // validation for constraint: array
        if ('' !== ($groupArrayErrorMessage = self::validateGroupForArrayConstraintsFromSetGroup($group))) {
            throw new \InvalidArgumentException($groupArrayErrorMessage, __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Add item to group value
     * @throws \InvalidArgumentException
     * @param \StructType\Group $item
     * @return \StructType\Report
     */
    public function addToGroup(\StructType\Group $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Group) {
            throw new \InvalidArgumentException(sprintf('The group property can only contain items of type \StructType\Group, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->group[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Report
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Report
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get styp value
     * @return string
     */
    public function getStyp()
    {
        return $this->styp;
    }
    /**
     * Set styp value
     * @param string $styp
     * @return \StructType\Report
     */
    public function setStyp($styp = null)
    {
        // validation for constraint: string
        if (!is_null($styp) && !is_string($styp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($styp, true), gettype($styp)), __LINE__);
        }
        $this->styp = $styp;
        return $this;
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param string $index
     * @return \StructType\Report
     */
    public function setIndex($index = null)
    {
        // validation for constraint: string
        if (!is_null($index) && !is_string($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get lagomid value
     * @return string|null
     */
    public function getLagomid()
    {
        return $this->lagomid;
    }
    /**
     * Set lagomid value
     * @param string $lagomid
     * @return \StructType\Report
     */
    public function setLagomid($lagomid = null)
    {
        // validation for constraint: string
        if (!is_null($lagomid) && !is_string($lagomid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lagomid, true), gettype($lagomid)), __LINE__);
        }
        $this->lagomid = $lagomid;
        return $this;
    }
    /**
     * Get lagomlopnr value
     * @return string|null
     */
    public function getLagomlopnr()
    {
        return $this->lagomlopnr;
    }
    /**
     * Set lagomlopnr value
     * @param string $lagomlopnr
     * @return \StructType\Report
     */
    public function setLagomlopnr($lagomlopnr = null)
    {
        // validation for constraint: string
        if (!is_null($lagomlopnr) && !is_string($lagomlopnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lagomlopnr, true), gettype($lagomlopnr)), __LINE__);
        }
        $this->lagomlopnr = $lagomlopnr;
        return $this;
    }
}
