<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ping StructType
 * @subpackage Structs
 */
class Ping extends AbstractStructBase
{
    /**
     * The lang
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $lang;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $version;
    /**
     * Constructor method for ping
     * @uses Ping::setLang()
     * @uses Ping::setVersion()
     * @param string $lang
     * @param string $version
     */
    public function __construct($lang = null, $version = null)
    {
        $this
            ->setLang($lang)
            ->setVersion($version);
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lang
     * @return \StructType\Ping
     */
    public function setLang($lang = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($lang) ? implode(', ', $lang) : var_export($lang, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Ping
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
