<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lagomlista StructType
 * @subpackage Structs
 */
class Lagomlista extends AbstractStructBase
{
    /**
     * The group
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: ucOrderReply:group
     * @var \StructType\Group[]
     */
    public $group;
    /**
     * Constructor method for lagomlista
     * @uses Lagomlista::setGroup()
     * @param \StructType\Group[] $group
     */
    public function __construct(array $group = array())
    {
        $this
            ->setGroup($group);
    }
    /**
     * Get group value
     * @return \StructType\Group[]
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * This method is responsible for validating the values passed to the setGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupForArrayConstraintsFromSetGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lagomlistaGroupItem) {
            // validation for constraint: itemType
            if (!$lagomlistaGroupItem instanceof \StructType\Group) {
                $invalidValues[] = is_object($lagomlistaGroupItem) ? get_class($lagomlistaGroupItem) : sprintf('%s(%s)', gettype($lagomlistaGroupItem), var_export($lagomlistaGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The group property can only contain items of type \StructType\Group, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set group value
     * @throws \InvalidArgumentException
     * @param \StructType\Group[] $group
     * @return \StructType\Lagomlista
     */
    public function setGroup(array $group = array())
    {
        // validation for constraint: array
        if ('' !== ($groupArrayErrorMessage = self::validateGroupForArrayConstraintsFromSetGroup($group))) {
            throw new \InvalidArgumentException($groupArrayErrorMessage, __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Add item to group value
     * @throws \InvalidArgumentException
     * @param \StructType\Group $item
     * @return \StructType\Lagomlista
     */
    public function addToGroup(\StructType\Group $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Group) {
            throw new \InvalidArgumentException(sprintf('The group property can only contain items of type \StructType\Group, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->group[] = $item;
        return $this;
    }
}
