<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for individualReport StructType
 * @subpackage Structs
 */
class IndividualReport extends AbstractStructBase
{
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The individualReportQuery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReportQuery
     */
    public $individualReportQuery;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $product;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The repositoryaction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $repositoryaction;
    /**
     * Constructor method for individualReport
     * @uses IndividualReport::setCustomer()
     * @uses IndividualReport::setIndividualReportQuery()
     * @uses IndividualReport::setProduct()
     * @uses IndividualReport::setVersion()
     * @uses IndividualReport::setRepositoryaction()
     * @param \StructType\Customer $customer
     * @param \StructType\ReportQuery $individualReportQuery
     * @param string $product
     * @param string $version
     * @param string $repositoryaction
     */
    public function __construct(\StructType\Customer $customer = null, \StructType\ReportQuery $individualReportQuery = null, $product = null, $version = null, $repositoryaction = null)
    {
        $this
            ->setCustomer($customer)
            ->setIndividualReportQuery($individualReportQuery)
            ->setProduct($product)
            ->setVersion($version)
            ->setRepositoryaction($repositoryaction);
    }
    /**
     * Get customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\IndividualReport
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get individualReportQuery value
     * @return \StructType\ReportQuery
     */
    public function getIndividualReportQuery()
    {
        return $this->individualReportQuery;
    }
    /**
     * Set individualReportQuery value
     * @param \StructType\ReportQuery $individualReportQuery
     * @return \StructType\IndividualReport
     */
    public function setIndividualReportQuery(\StructType\ReportQuery $individualReportQuery = null)
    {
        $this->individualReportQuery = $individualReportQuery;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\IndividualProduct::valueIsValid()
     * @uses \EnumType\IndividualProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\IndividualReport
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndividualProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IndividualProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\IndividualProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\IndividualReport
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get repositoryaction value
     * @return string|null
     */
    public function getRepositoryaction()
    {
        return $this->repositoryaction;
    }
    /**
     * Set repositoryaction value
     * @uses \EnumType\Repositoryaction::valueIsValid()
     * @uses \EnumType\Repositoryaction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repositoryaction
     * @return \StructType\IndividualReport
     */
    public function setRepositoryaction($repositoryaction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Repositoryaction::valueIsValid($repositoryaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Repositoryaction', is_array($repositoryaction) ? implode(', ', $repositoryaction) : var_export($repositoryaction, true), implode(', ', \EnumType\Repositoryaction::getValidValues())), __LINE__);
        }
        $this->repositoryaction = $repositoryaction;
        return $this;
    }
}
