<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for identitySeekFys StructType
 * @subpackage Structs
 */
class IdentitySeekFys extends AbstractStructBase
{
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The seekFysiker
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeekFysiker
     */
    public $seekFysiker;
    /**
     * The identifier
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - minLength: 10
     * - pattern: \d{6}-\d{4}|\d{10}
     * - use: required
     * @var string
     */
    public $identifier;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * Constructor method for identitySeekFys
     * @uses IdentitySeekFys::setCustomer()
     * @uses IdentitySeekFys::setSeekFysiker()
     * @uses IdentitySeekFys::setIdentifier()
     * @uses IdentitySeekFys::setVersion()
     * @param \StructType\Customer $customer
     * @param \StructType\SeekFysiker $seekFysiker
     * @param string $identifier
     * @param string $version
     */
    public function __construct(\StructType\Customer $customer = null, \StructType\SeekFysiker $seekFysiker = null, $identifier = null, $version = null)
    {
        $this
            ->setCustomer($customer)
            ->setSeekFysiker($seekFysiker)
            ->setIdentifier($identifier)
            ->setVersion($version);
    }
    /**
     * Get customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\IdentitySeekFys
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get seekFysiker value
     * @return \StructType\SeekFysiker
     */
    public function getSeekFysiker()
    {
        return $this->seekFysiker;
    }
    /**
     * Set seekFysiker value
     * @param \StructType\SeekFysiker $seekFysiker
     * @return \StructType\IdentitySeekFys
     */
    public function setSeekFysiker(\StructType\SeekFysiker $seekFysiker = null)
    {
        $this->seekFysiker = $seekFysiker;
        return $this;
    }
    /**
     * Get identifier value
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param string $identifier
     * @return \StructType\IdentitySeekFys
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($identifier) && mb_strlen($identifier) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($identifier)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($identifier) && mb_strlen($identifier) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($identifier)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($identifier) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($identifier, true)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\IdentitySeekFys
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
