<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for identityCheck StructType
 * @subpackage Structs
 */
class IdentityCheck extends AbstractStructBase
{
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The identifier
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - minLength: 10
     * - pattern: \d{6}-\d{4}|\d{10}
     * - use: required
     * @var string
     */
    public $identifier;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The worksites
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $worksites;
    /**
     * Constructor method for identityCheck
     * @uses IdentityCheck::setCustomer()
     * @uses IdentityCheck::setIdentifier()
     * @uses IdentityCheck::setVersion()
     * @uses IdentityCheck::setWorksites()
     * @param \StructType\Customer $customer
     * @param string $identifier
     * @param string $version
     * @param bool $worksites
     */
    public function __construct(\StructType\Customer $customer = null, $identifier = null, $version = null, $worksites = null)
    {
        $this
            ->setCustomer($customer)
            ->setIdentifier($identifier)
            ->setVersion($version)
            ->setWorksites($worksites);
    }
    /**
     * Get customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\IdentityCheck
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get identifier value
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param string $identifier
     * @return \StructType\IdentityCheck
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($identifier) && mb_strlen($identifier) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($identifier)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($identifier) && mb_strlen($identifier) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($identifier)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($identifier) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($identifier, true)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\IdentityCheck
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get worksites value
     * @return bool|null
     */
    public function getWorksites()
    {
        return $this->worksites;
    }
    /**
     * Set worksites value
     * @param bool $worksites
     * @return \StructType\IdentityCheck
     */
    public function setWorksites($worksites = null)
    {
        // validation for constraint: boolean
        if (!is_null($worksites) && !is_bool($worksites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($worksites, true), gettype($worksites)), __LINE__);
        }
        $this->worksites = $worksites;
        return $this;
    }
}
