<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for group StructType
 * @subpackage Structs
 */
class Group extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The index
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The term
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ucOrderReply:term
     * @var \StructType\Term[]
     */
    public $term;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $key;
    /**
     * Constructor method for group
     * @uses Group::setId()
     * @uses Group::setIndex()
     * @uses Group::setName()
     * @uses Group::setTerm()
     * @uses Group::setKey()
     * @param string $id
     * @param string $index
     * @param string $name
     * @param \StructType\Term[] $term
     * @param string $key
     */
    public function __construct($id = null, $index = null, $name = null, array $term = array(), $key = null)
    {
        $this
            ->setId($id)
            ->setIndex($index)
            ->setName($name)
            ->setTerm($term)
            ->setKey($key);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Group
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param string $index
     * @return \StructType\Group
     */
    public function setIndex($index = null)
    {
        // validation for constraint: string
        if (!is_null($index) && !is_string($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Group
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get term value
     * @return \StructType\Term[]|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * This method is responsible for validating the values passed to the setTerm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTerm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermForArrayConstraintsFromSetTerm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $groupTermItem) {
            // validation for constraint: itemType
            if (!$groupTermItem instanceof \StructType\Term) {
                $invalidValues[] = is_object($groupTermItem) ? get_class($groupTermItem) : sprintf('%s(%s)', gettype($groupTermItem), var_export($groupTermItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The term property can only contain items of type \StructType\Term, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set term value
     * @throws \InvalidArgumentException
     * @param \StructType\Term[] $term
     * @return \StructType\Group
     */
    public function setTerm(array $term = array())
    {
        // validation for constraint: array
        if ('' !== ($termArrayErrorMessage = self::validateTermForArrayConstraintsFromSetTerm($term))) {
            throw new \InvalidArgumentException($termArrayErrorMessage, __LINE__);
        }
        $this->term = $term;
        return $this;
    }
    /**
     * Add item to term value
     * @throws \InvalidArgumentException
     * @param \StructType\Term $item
     * @return \StructType\Group
     */
    public function addToTerm(\StructType\Term $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Term) {
            throw new \InvalidArgumentException(sprintf('The term property can only contain items of type \StructType\Term, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->term[] = $item;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\Group
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
}
