<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extras StructType
 * @subpackage Structs
 */
class Extras extends AbstractStructBase
{
    /**
     * The bokslut
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 1
     * @var \StructType\Bokslut[]
     */
    public $bokslut;
    /**
     * The telefax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $telefax;
    /**
     * The emailId
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:nameBase
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: .*@.*
     * @var string
     */
    public $emailId;
    /**
     * The object
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 10
     * - minOccurs: 0
     * - pattern: \d{6}-\d{4}|\d{10}
     * @var string
     */
    public $object;
    /**
     * The coverage
     * @var \StructType\Coverage
     */
    public $coverage;
    /**
     * The originalDocuments
     * @var \StructType\OriginalDocuments
     */
    public $originalDocuments;
    /**
     * The accountsCoverage
     * @var \StructType\AccountsCoverage
     */
    public $accountsCoverage;
    /**
     * The deliveryForm
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $deliveryForm;
    /**
     * Constructor method for extras
     * @uses Extras::setBokslut()
     * @uses Extras::setTelefax()
     * @uses Extras::setEmailId()
     * @uses Extras::setObject()
     * @uses Extras::setCoverage()
     * @uses Extras::setOriginalDocuments()
     * @uses Extras::setAccountsCoverage()
     * @uses Extras::setDeliveryForm()
     * @param \StructType\Bokslut[] $bokslut
     * @param \StructType\Telephone $telefax
     * @param string $emailId
     * @param string $object
     * @param \StructType\Coverage $coverage
     * @param \StructType\OriginalDocuments $originalDocuments
     * @param \StructType\AccountsCoverage $accountsCoverage
     * @param string $deliveryForm
     */
    public function __construct(array $bokslut = array(), \StructType\Telephone $telefax = null, $emailId = null, $object = null, \StructType\Coverage $coverage = null, \StructType\OriginalDocuments $originalDocuments = null, \StructType\AccountsCoverage $accountsCoverage = null, $deliveryForm = null)
    {
        $this
            ->setBokslut($bokslut)
            ->setTelefax($telefax)
            ->setEmailId($emailId)
            ->setObject($object)
            ->setCoverage($coverage)
            ->setOriginalDocuments($originalDocuments)
            ->setAccountsCoverage($accountsCoverage)
            ->setDeliveryForm($deliveryForm);
    }
    /**
     * Get bokslut value
     * @return \StructType\Bokslut[]
     */
    public function getBokslut()
    {
        return $this->bokslut;
    }
    /**
     * This method is responsible for validating the values passed to the setBokslut method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBokslut method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBokslutForArrayConstraintsFromSetBokslut(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extrasBokslutItem) {
            // validation for constraint: itemType
            if (!$extrasBokslutItem instanceof \StructType\Bokslut) {
                $invalidValues[] = is_object($extrasBokslutItem) ? get_class($extrasBokslutItem) : sprintf('%s(%s)', gettype($extrasBokslutItem), var_export($extrasBokslutItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bokslut property can only contain items of type \StructType\Bokslut, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bokslut value
     * @throws \InvalidArgumentException
     * @param \StructType\Bokslut[] $bokslut
     * @return \StructType\Extras
     */
    public function setBokslut(array $bokslut = array())
    {
        // validation for constraint: array
        if ('' !== ($bokslutArrayErrorMessage = self::validateBokslutForArrayConstraintsFromSetBokslut($bokslut))) {
            throw new \InvalidArgumentException($bokslutArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($bokslut) && count($bokslut) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($bokslut)), __LINE__);
        }
        $this->bokslut = $bokslut;
        return $this;
    }
    /**
     * Add item to bokslut value
     * @throws \InvalidArgumentException
     * @param \StructType\Bokslut $item
     * @return \StructType\Extras
     */
    public function addToBokslut(\StructType\Bokslut $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bokslut) {
            throw new \InvalidArgumentException(sprintf('The bokslut property can only contain items of type \StructType\Bokslut, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->bokslut) && count($this->bokslut) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->bokslut)), __LINE__);
        }
        $this->bokslut[] = $item;
        return $this;
    }
    /**
     * Get telefax value
     * @return \StructType\Telephone|null
     */
    public function getTelefax()
    {
        return $this->telefax;
    }
    /**
     * Set telefax value
     * @param \StructType\Telephone $telefax
     * @return \StructType\Extras
     */
    public function setTelefax(\StructType\Telephone $telefax = null)
    {
        $this->telefax = $telefax;
        return $this;
    }
    /**
     * Get emailId value
     * @return string|null
     */
    public function getEmailId()
    {
        return $this->emailId;
    }
    /**
     * Set emailId value
     * @param string $emailId
     * @return \StructType\Extras
     */
    public function setEmailId($emailId = null)
    {
        // validation for constraint: string
        if (!is_null($emailId) && !is_string($emailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailId, true), gettype($emailId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($emailId) && mb_strlen($emailId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($emailId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($emailId) && mb_strlen($emailId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($emailId)), __LINE__);
        }
        // validation for constraint: pattern(.*@.*)
        if (!is_null($emailId) && !preg_match('/.*@.*/', $emailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression .*@.*', var_export($emailId, true)), __LINE__);
        }
        $this->emailId = $emailId;
        return $this;
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return \StructType\Extras
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($object, true), gettype($object)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($object) && mb_strlen($object) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($object)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($object) && mb_strlen($object) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($object)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($object) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($object, true)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get coverage value
     * @return \StructType\Coverage|null
     */
    public function getCoverage()
    {
        return $this->coverage;
    }
    /**
     * Set coverage value
     * @param \StructType\Coverage $coverage
     * @return \StructType\Extras
     */
    public function setCoverage(\StructType\Coverage $coverage = null)
    {
        $this->coverage = $coverage;
        return $this;
    }
    /**
     * Get originalDocuments value
     * @return \StructType\OriginalDocuments|null
     */
    public function getOriginalDocuments()
    {
        return $this->originalDocuments;
    }
    /**
     * Set originalDocuments value
     * @param \StructType\OriginalDocuments $originalDocuments
     * @return \StructType\Extras
     */
    public function setOriginalDocuments(\StructType\OriginalDocuments $originalDocuments = null)
    {
        $this->originalDocuments = $originalDocuments;
        return $this;
    }
    /**
     * Get accountsCoverage value
     * @return \StructType\AccountsCoverage|null
     */
    public function getAccountsCoverage()
    {
        return $this->accountsCoverage;
    }
    /**
     * Set accountsCoverage value
     * @param \StructType\AccountsCoverage $accountsCoverage
     * @return \StructType\Extras
     */
    public function setAccountsCoverage(\StructType\AccountsCoverage $accountsCoverage = null)
    {
        $this->accountsCoverage = $accountsCoverage;
        return $this;
    }
    /**
     * Get deliveryForm value
     * @return string|null
     */
    public function getDeliveryForm()
    {
        return $this->deliveryForm;
    }
    /**
     * Set deliveryForm value
     * @uses \EnumType\DeliveryMedia::valueIsValid()
     * @uses \EnumType\DeliveryMedia::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryForm
     * @return \StructType\Extras
     */
    public function setDeliveryForm($deliveryForm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMedia::valueIsValid($deliveryForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveryMedia', is_array($deliveryForm) ? implode(', ', $deliveryForm) : var_export($deliveryForm, true), implode(', ', \EnumType\DeliveryMedia::getValidValues())), __LINE__);
        }
        $this->deliveryForm = $deliveryForm;
        return $this;
    }
}
