<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minLength: 5
     * - minOccurs: 1
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 2
     * - minOccurs: 1
     * @var string
     */
    public $password;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:nameBase
     * - maxLength: 48
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The changePassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $changePassword;
    /**
     * Constructor method for customer
     * @uses Customer::setUserId()
     * @uses Customer::setPassword()
     * @uses Customer::setName()
     * @uses Customer::setChangePassword()
     * @param string $userId
     * @param string $password
     * @param string $name
     * @param bool $changePassword
     */
    public function __construct($userId = null, $password = null, $name = null, $changePassword = null)
    {
        $this
            ->setUserId($userId)
            ->setPassword($password)
            ->setName($name)
            ->setChangePassword($changePassword);
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\Customer
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($userId) && mb_strlen($userId) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($userId) && mb_strlen($userId) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Customer
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($password) && mb_strlen($password) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($password)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($password) && mb_strlen($password) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Customer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(48)
        if (!is_null($name) && mb_strlen($name) > 48) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 48', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get changePassword value
     * @return bool|null
     */
    public function getChangePassword()
    {
        return $this->changePassword;
    }
    /**
     * Set changePassword value
     * @param bool $changePassword
     * @return \StructType\Customer
     */
    public function setChangePassword($changePassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($changePassword) && !is_bool($changePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changePassword, true), gettype($changePassword)), __LINE__);
        }
        $this->changePassword = $changePassword;
        return $this;
    }
}
